/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.cluster.ClusterIdFactory;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterIdGeneratorPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterIdGeneratorPeriodical.class);
    private final ClusterConfigService clusterConfigService;
    private final ClusterIdFactory clusterIdFactory;

    @Inject
    public ClusterIdGeneratorPeriodical(ClusterConfigService clusterConfigService, ClusterIdFactory clusterIdFactory) {
        this.clusterConfigService = clusterConfigService;
        this.clusterIdFactory = clusterIdFactory;
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        if (this.clusterConfigService.get(ClusterId.class) == null) {
            ClusterId clusterId = this.clusterIdFactory.create();
            this.clusterConfigService.write(clusterId);
            LOG.debug("Generated cluster ID {}", (Object)clusterId.clusterId());
        }
    }
}

