/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePingThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(NodePingThread.class);
    private final NodeService nodeService;
    private final NotificationService notificationService;
    private final ActivityWriter activityWriter;
    private final HttpConfiguration httpConfiguration;
    private final ServerStatus serverStatus;

    @Inject
    public NodePingThread(NodeService nodeService, NotificationService notificationService, ActivityWriter activityWriter, HttpConfiguration httpConfiguration, ServerStatus serverStatus) {
        this.nodeService = nodeService;
        this.notificationService = notificationService;
        this.activityWriter = activityWriter;
        this.httpConfiguration = httpConfiguration;
        this.serverStatus = serverStatus;
    }

    @Override
    public void doRun() {
        boolean isMaster = this.serverStatus.hasCapability(ServerStatus.Capability.MASTER);
        try {
            Node node = this.nodeService.byNodeId(this.serverStatus.getNodeId());
            this.nodeService.markAsAlive(node, isMaster, this.httpConfiguration.getHttpPublishUri().resolve("api/"));
        }
        catch (NodeNotFoundException e) {
            LOG.warn("Did not find meta info of this node. Re-registering.");
            this.nodeService.registerServer(this.serverStatus.getNodeId().toString(), isMaster, this.httpConfiguration.getHttpPublishUri().resolve("api/"), Tools.getLocalCanonicalHostname());
        }
        try {
            Notification notification;
            this.nodeService.dropOutdated();
            if (this.nodeService.isAnyMasterPresent()) {
                notification = this.notificationService.build().addType(Notification.Type.NO_MASTER);
                boolean removedNotification = this.notificationService.fixed(notification);
                if (removedNotification) {
                    this.activityWriter.write(new Activity("Notification condition [" + (Object)((Object)Notification.Type.NO_MASTER) + "] has been fixed.", NodePingThread.class));
                }
            } else {
                notification = this.notificationService.buildNow().addNode(this.serverStatus.getNodeId().toString()).addType(Notification.Type.NO_MASTER).addSeverity(Notification.Severity.URGENT);
                this.notificationService.publishIfFirst(notification);
            }
        }
        catch (Exception e) {
            LOG.warn("Caught exception during node ping.", (Throwable)e);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }
}

