/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.lookup;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.utilities.ObjectUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LookupDataAdapter
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(LookupDataAdapter.class);
    private final String id;
    private final String name;
    private final LookupDataAdapterConfiguration config;
    private final Timer requestTimer;
    private final Timer refreshTimer;
    private LookupResult resultWithError;
    private AtomicReference<Throwable> dataSourceError = new AtomicReference();

    protected LookupDataAdapter(DataAdapterDto dto, MetricRegistry metricRegistry) {
        this(dto.id(), dto.name(), dto.config(), metricRegistry);
        boolean errorTTLEnabled = Optional.ofNullable(dto.customErrorTTLEnabled()).orElse(false);
        if (errorTTLEnabled && dto.customErrorTTLUnit() != null && dto.customErrorTTL() != null) {
            this.resultWithError = LookupResult.withError(dto.customErrorTTLUnit().toMillis(dto.customErrorTTL()));
        }
    }

    protected LookupDataAdapter(String id, String name, LookupDataAdapterConfiguration config, MetricRegistry metricRegistry) {
        this.id = id;
        this.name = name;
        this.config = config;
        this.requestTimer = metricRegistry.timer(MetricRegistry.name((String)"org.graylog2.lookup.adapters", (String[])new String[]{id, "requests"}));
        this.refreshTimer = metricRegistry.timer(MetricRegistry.name((String)"org.graylog2.lookup.adapters", (String[])new String[]{id, "refresh"}));
        this.resultWithError = LookupResult.withError();
    }

    public LookupResult getErrorResult() {
        return this.resultWithError;
    }

    public LookupResult getEmptyResult() {
        return LookupResult.empty();
    }

    protected void startUp() throws Exception {
        try {
            this.doStart();
        }
        catch (Exception e) {
            LOG.error("Couldn't start data adapter <{}/{}/@{}>", new Object[]{this.name(), this.id(), ObjectUtils.objectId((Object)this), e});
            this.setError(e);
        }
    }

    protected abstract void doStart() throws Exception;

    protected void shutDown() throws Exception {
        try {
            this.doStop();
        }
        catch (Exception e) {
            LOG.error("Couldn't stop data adapter <{}/{}/@{}>", new Object[]{this.name(), this.id(), ObjectUtils.objectId((Object)this), e});
        }
    }

    protected abstract void doStop() throws Exception;

    public abstract Duration refreshInterval();

    public void refresh(LookupCachePurge cachePurge) {
        try (Timer.Context ignored = this.refreshTimer.time();){
            this.doRefresh(cachePurge);
        }
        catch (Exception e) {
            LOG.error("Couldn't refresh data adapter <{}/{}/@{}>", new Object[]{this.name(), this.id(), ObjectUtils.objectId((Object)this), e});
        }
    }

    protected abstract void doRefresh(LookupCachePurge var1) throws Exception;

    protected void clearError() {
        this.dataSourceError.set(null);
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.dataSourceError.get());
    }

    protected void setError(Throwable throwable) {
        this.dataSourceError.set(throwable);
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public LookupResult get(Object key) {
        if (this.state() == Service.State.FAILED) {
            return this.getErrorResult();
        }
        Preconditions.checkState((boolean)this.isRunning(), (Object)"Data adapter needs to be started before it can be used");
        try (Timer.Context ignored = this.requestTimer.time();){
            LookupResult lookupResult = this.doGet(key);
            return lookupResult;
        }
    }

    protected abstract LookupResult doGet(Object var1);

    @Deprecated
    public abstract void set(Object var1, Object var2);

    public LookupResult setValue(Object key, Object value) {
        return this.resultWithError;
    }

    public LookupResult setStringList(Object key, List<String> listValue) {
        return this.resultWithError;
    }

    public LookupResult addStringList(Object key, List<String> listValue, boolean keepDuplicates) {
        return this.resultWithError;
    }

    public LookupResult removeStringList(Object key, List<String> listValue) {
        return this.resultWithError;
    }

    public void clearKey(Object key) {
    }

    public LookupDataAdapterConfiguration getConfig() {
        return this.config;
    }

    public static abstract class Descriptor<C extends LookupDataAdapterConfiguration> {
        private final String type;
        private final Class<C> configClass;

        public Descriptor(String type, Class<C> configClass) {
            this.type = type;
            this.configClass = configClass;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="config_class")
        public Class<C> getConfigClass() {
            return this.configClass;
        }

        @JsonProperty(value="default_config")
        public abstract C defaultConfiguration();
    }

    public static interface Factory2<T extends LookupDataAdapter> {
        public T create(@Assisted(value="dto") DataAdapterDto var1);

        public Descriptor getDescriptor();
    }

    public static interface Factory<T extends LookupDataAdapter> {
        public T create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        public Descriptor getDescriptor();
    }
}

