/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.rest.resources.streams.responses.AutoValue_AlertConditionTestResponse;
import org.graylog2.rest.resources.streams.responses.AutoValue_AlertConditionTestResponse_ErrorMessage;

@AutoValue
public abstract class AlertConditionTestResponse {
    @JsonProperty(value="triggered")
    public abstract boolean triggered();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="error")
    public boolean error() {
        return !this.errorMessages().isEmpty();
    }

    @JsonProperty(value="error_messages")
    public abstract ImmutableList<ErrorMessage> errorMessages();

    public static AlertConditionTestResponse create(boolean triggered, @Nullable String description) {
        return AlertConditionTestResponse.createResult(triggered, description, Collections.emptyList());
    }

    public static AlertConditionTestResponse createWithError(Throwable t) {
        return AlertConditionTestResponse.createResult(false, null, (Collection<ErrorMessage>)ImmutableList.of((Object)ErrorMessage.create(t)));
    }

    private static AlertConditionTestResponse createResult(boolean triggered, @Nullable String description, Collection<ErrorMessage> errorMessages) {
        return new AutoValue_AlertConditionTestResponse(triggered, Optional.ofNullable(description), (ImmutableList<ErrorMessage>)ImmutableList.copyOf(errorMessages));
    }

    @AutoValue
    public static abstract class ErrorMessage {
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="message")
        @Nullable
        public abstract String message();

        public static ErrorMessage create(Throwable t) {
            return new AutoValue_AlertConditionTestResponse_ErrorMessage(t.getClass().getCanonicalName(), t.getMessage());
        }
    }
}

