/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.glassfish.grizzly.http.server.Request;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.models.system.sessions.responses.SessionResponseFactory;
import org.graylog2.rest.models.system.sessions.responses.SessionValidationResponse;
import org.graylog2.security.headerauth.HTTPHeaderAuthConfig;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.ActorAwareAuthenticationToken;
import org.graylog2.shared.security.ActorAwareAuthenticationTokenFactory;
import org.graylog2.shared.security.AuthenticationServiceUnavailableException;
import org.graylog2.shared.security.SessionCreator;
import org.graylog2.shared.security.ShiroAuthenticationFilter;
import org.graylog2.shared.security.ShiroRequestHeadersBinder;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.shared.users.UserService;
import org.graylog2.utilities.IpSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/system/sessions")
@Api(value="System/Sessions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SessionsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SessionsResource.class);
    private final DefaultSecurityManager securityManager;
    private final ShiroAuthenticationFilter authenticationFilter;
    private final Set<IpSubnet> trustedSubnets;
    private final Request grizzlyRequest;
    private final SessionCreator sessionCreator;
    private final ActorAwareAuthenticationTokenFactory tokenFactory;
    private final SessionResponseFactory sessionResponseFactory;
    private final ClusterConfigService clusterConfigService;
    private static final String USERNAME = "username";

    @Inject
    public SessionsResource(UserService userService, DefaultSecurityManager securityManager, ShiroAuthenticationFilter authenticationFilter, @Named(value="trusted_proxies") Set<IpSubnet> trustedSubnets, @Context Request grizzlyRequest, SessionCreator sessionCreator, ActorAwareAuthenticationTokenFactory tokenFactory, SessionResponseFactory sessionResponseFactory, ClusterConfigService clusterConfigService) {
        this.userService = userService;
        this.securityManager = securityManager;
        this.authenticationFilter = authenticationFilter;
        this.trustedSubnets = trustedSubnets;
        this.grizzlyRequest = grizzlyRequest;
        this.sessionCreator = sessionCreator;
        this.tokenFactory = tokenFactory;
        this.sessionResponseFactory = sessionResponseFactory;
        this.clusterConfigService = clusterConfigService;
    }

    @POST
    @ApiOperation(value="Create a new session", notes="This request creates a new session for a user or reactivates an existing session: the equivalent of logging in.")
    @NoAuditEvent(value="dispatches audit events in the method body")
    public JsonNode newSession(@Context ContainerRequestContext requestContext, @ApiParam(name="Login request", value="Credentials. The default implementation requires presence of two properties: 'username' and 'password'. However a plugin may customize which kind of credentials are accepted and therefore expect different properties.", required=true) @NotNull JsonNode createRequest) {
        ActorAwareAuthenticationToken authToken;
        this.rejectServiceAccount(createRequest);
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (!(securityContext instanceof ShiroSecurityContext)) {
            throw new InternalServerErrorException("Unsupported SecurityContext class, this is a bug!");
        }
        ShiroSecurityContext shiroSecurityContext = (ShiroSecurityContext)securityContext;
        try {
            authToken = this.tokenFactory.forRequestBody(createRequest);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
        String sessionId = shiroSecurityContext.getUsername();
        String host = RestTools.getRemoteAddrFromRequest(this.grizzlyRequest, this.trustedSubnets);
        try {
            Optional<Session> session = this.sessionCreator.create(sessionId, host, authToken);
            if (session.isPresent()) {
                return this.sessionResponseFactory.forSession(session.get());
            }
            throw new NotAuthorizedException("Invalid credentials.", (Object)"Basic realm=\"Graylog Server session\"", new Object[0]);
        }
        catch (AuthenticationServiceUnavailableException e) {
            throw new ServiceUnavailableException("Authentication service unavailable");
        }
    }

    private void rejectServiceAccount(JsonNode createRequest) {
        User user;
        if (createRequest.has(USERNAME) && (user = this.userService.load(createRequest.get(USERNAME).asText())) != null && user.isServiceAccount()) {
            throw new BadRequestException("Cannot login with service account " + user.getName());
        }
    }

    @GET
    @ApiOperation(value="Validate an existing session", notes="Checks the session with the given ID: returns http status 204 (No Content) if session is valid.", code=204)
    public SessionValidationResponse validateSession(@Context ContainerRequestContext requestContext) {
        try {
            this.authenticationFilter.filter(requestContext);
        }
        catch (IOException | NotAuthorizedException | LockedAccountException e) {
            return SessionValidationResponse.invalid();
        }
        Subject subject = this.getSubject();
        if (!subject.isAuthenticated()) {
            return SessionValidationResponse.invalid();
        }
        if (subject.getSession(false) == null && ShiroSecurityContext.isSessionCreationRequested()) {
            Session session = subject.getSession();
            String userId = subject.getPrincipal().toString();
            User user = this.userService.loadById(userId);
            if (user == null) {
                throw new InternalServerErrorException("Unable to load user with ID <" + userId + ">.");
            }
            session.setAttribute((Object)USERNAME, (Object)user.getName());
            HTTPHeaderAuthConfig httpHeaderConfig = this.loadHTTPHeaderConfig();
            Optional<String> usernameHeader = ShiroRequestHeadersBinder.getHeaderFromThreadContext(httpHeaderConfig.usernameHeader());
            if (httpHeaderConfig.enabled() && usernameHeader.isPresent()) {
                session.setAttribute((Object)"http-header-auth-user", (Object)usernameHeader.get());
            }
            LOG.debug("Create session for <{}>", (Object)user.getName());
            session.touch();
            ((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getSubjectDAO().save(subject);
            return SessionValidationResponse.validWithNewSession(String.valueOf(session.getId()), String.valueOf(user.getName()));
        }
        return SessionValidationResponse.valid();
    }

    @DELETE
    @ApiOperation(value="Terminate an existing session", notes="Destroys the session with the given ID: the equivalent of logging out.")
    @Path(value="/{sessionId}")
    @RequiresAuthentication
    @AuditEvent(type="server:session:delete")
    public void terminateSession(@ApiParam(name="sessionId", required=true) @PathParam(value="sessionId") String sessionId) {
        Subject subject = this.getSubject();
        this.securityManager.logout(subject);
    }

    private HTTPHeaderAuthConfig loadHTTPHeaderConfig() {
        return this.clusterConfigService.getOrDefault(HTTPHeaderAuthConfig.class, HTTPHeaderAuthConfig.createDisabled());
    }
}

