/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.security.AccessToken;
import org.joda.time.DateTime;

@CollectionName(value="access_tokens")
public class AccessTokenImpl
extends PersistedImpl
implements AccessToken {
    public static final String COLLECTION_NAME = "access_tokens";
    public static final String USERNAME = "username";
    public static final String TOKEN = "token";
    public static final String TOKEN_TYPE = "token_type";
    public static final String NAME = "NAME";
    public static final String LAST_ACCESS = "last_access";

    public AccessTokenImpl(Map<String, Object> fields) {
        super(fields);
    }

    public AccessTokenImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    @Override
    public Map<String, Validator> getValidations() {
        HashMap validations = Maps.newHashMap();
        validations.put(USERNAME, new FilledStringValidator());
        validations.put(TOKEN, new FilledStringValidator());
        validations.put(NAME, new FilledStringValidator());
        return validations;
    }

    @Override
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return null;
    }

    @Override
    public DateTime getLastAccess() {
        Object o = this.fields.get(LAST_ACCESS);
        return (DateTime)o;
    }

    @Override
    public String getUserName() {
        return String.valueOf(this.fields.get(USERNAME));
    }

    @Override
    public void setUserName(String userName) {
        this.fields.put(USERNAME, userName);
    }

    @Override
    public String getToken() {
        return String.valueOf(this.fields.get(TOKEN));
    }

    @Override
    public void setToken(String token) {
        this.fields.put(TOKEN, token);
        this.fields.put(TOKEN_TYPE, Type.AES_SIV.getIntValue());
    }

    @Override
    public String getName() {
        return String.valueOf(this.fields.get(NAME));
    }

    @Override
    public void setName(String name) {
        this.fields.put(NAME, name);
    }

    public static enum Type {
        PLAINTEXT(0),
        AES_SIV(1);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        public int getIntValue() {
            return this.type;
        }
    }
}

