/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.AutoValue_UserSessionTerminationService_GlobalTerminationRevisionConfig;
import org.graylog2.security.MongoDBSessionService;
import org.graylog2.security.MongoDbSession;
import org.graylog2.security.MongoDbSessionDAO;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.events.UserChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserSessionTerminationService
extends AbstractIdleService {
    private static final long TERMINATION_REVISION = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSessionTerminationService.class);
    private static final EnumSet<User.AccountStatus> SESSION_TERMINATION_STATUS = EnumSet.of(User.AccountStatus.DELETED, User.AccountStatus.DISABLED);
    private final MongoDbSessionDAO sessionDao;
    private final MongoDBSessionService sessionService;
    private final DefaultSecurityManager securityManager;
    private final ClusterConfigService clusterConfigService;
    private final UserService userService;
    private final ServerStatus serverStatus;
    private final EventBus eventBus;

    @Inject
    public UserSessionTerminationService(MongoDbSessionDAO sessionDao, MongoDBSessionService sessionService, DefaultSecurityManager securityManager, ClusterConfigService clusterConfigService, UserService userService, ServerStatus serverStatus, EventBus eventBus) {
        this.sessionDao = sessionDao;
        this.securityManager = securityManager;
        this.clusterConfigService = clusterConfigService;
        this.sessionService = sessionService;
        this.userService = userService;
        this.serverStatus = serverStatus;
        this.eventBus = eventBus;
    }

    @Subscribe
    public void handleUserChanged(UserChangedEvent event) {
        User user = this.userService.loadById(event.userId());
        if (user != null && SESSION_TERMINATION_STATUS.contains((Object)user.getAccountStatus())) {
            this.terminateSessionsForUser(user);
        }
    }

    protected void startUp() throws Exception {
        try {
            this.runGlobalSessionTermination();
        }
        catch (Exception e) {
            LOG.error("Couldn't run global session termination", (Throwable)e);
        }
        this.eventBus.register((Object)this);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
    }

    private boolean isNotPrimaryNode() {
        return !this.serverStatus.hasCapability(ServerStatus.Capability.MASTER);
    }

    private void runGlobalSessionTermination() {
        if (this.isNotPrimaryNode()) {
            LOG.debug("Only run on the primary node to avoid concurrent session termination");
            return;
        }
        GlobalTerminationRevisionConfig globalTerminationRevisionConfig = this.clusterConfigService.getOrDefault(GlobalTerminationRevisionConfig.class, GlobalTerminationRevisionConfig.initial());
        if (!globalTerminationRevisionConfig.isOutdated()) {
            LOG.debug("Global session termination not required");
            return;
        }
        long terminatedSessions = 0L;
        for (Session activeSession : this.sessionDao.getActiveSessions()) {
            this.terminateSessionForID(activeSession.getId());
            ++terminatedSessions;
        }
        LOG.info("Globally terminated {} session(s)", (Object)terminatedSessions);
        this.clusterConfigService.write(GlobalTerminationRevisionConfig.withCurrentRevision());
    }

    private void terminateSessionsForUser(User user) {
        try {
            Set<String> sessionIds = this.getSessionIDsForUser(user);
            for (String sessionId : sessionIds) {
                this.getActiveSessionForID((Serializable)((Object)sessionId)).ifPresent(session -> {
                    LOG.info("Terminating session for user <{}/{}>", (Object)user.getName(), (Object)user.getId());
                    session.stop();
                });
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't terminate session for user <{}/{}>", new Object[]{user.getName(), user.getId(), e});
        }
    }

    private void terminateSessionForID(Serializable sessionId) {
        try {
            this.getActiveSessionForID(sessionId).ifPresent(Session::stop);
        }
        catch (Exception e) {
            LOG.error("Couldn't terminate session", (Throwable)e);
        }
    }

    private Optional<Session> getActiveSessionForID(Serializable sessionId) {
        SessionManager sessionManager = this.securityManager.getSessionManager();
        try {
            return Optional.ofNullable(sessionManager.getSession((SessionKey)new DefaultSessionKey(sessionId)));
        }
        catch (ExpiredSessionException e) {
            return Optional.empty();
        }
    }

    private Set<String> getSessionIDsForUser(User user) {
        String userId = Objects.requireNonNull(user.getId(), "user ID cannot be null");
        return this.sessionService.loadAll().stream().filter(session -> userId.equals(session.getUserIdAttribute().orElse(null))).map(MongoDbSession::getSessionId).collect(Collectors.toSet());
    }

    @AutoValue
    public static abstract class GlobalTerminationRevisionConfig {
        @JsonProperty(value="applied_revision")
        public abstract long appliedRevision();

        public static GlobalTerminationRevisionConfig initial() {
            return GlobalTerminationRevisionConfig.create(0L);
        }

        public static GlobalTerminationRevisionConfig withCurrentRevision() {
            return GlobalTerminationRevisionConfig.create(1L);
        }

        @JsonIgnore
        public boolean isOutdated() {
            return this.appliedRevision() < 1L;
        }

        @JsonCreator
        public static GlobalTerminationRevisionConfig create(@JsonProperty(value="applied_revision") long appliedRevision) {
            return new AutoValue_UserSessionTerminationService_GlobalTerminationRevisionConfig(appliedRevision);
        }
    }
}

