/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.encryption;

import org.graylog2.security.encryption.EncryptedValue;

final class AutoValue_EncryptedValue
extends EncryptedValue {
    private final String value;
    private final String salt;
    private final boolean isKeepValue;
    private final boolean isDeleteValue;

    private AutoValue_EncryptedValue(String value, String salt, boolean isKeepValue, boolean isDeleteValue) {
        this.value = value;
        this.salt = salt;
        this.isKeepValue = isKeepValue;
        this.isDeleteValue = isDeleteValue;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String salt() {
        return this.salt;
    }

    @Override
    public boolean isKeepValue() {
        return this.isKeepValue;
    }

    @Override
    public boolean isDeleteValue() {
        return this.isDeleteValue;
    }

    public String toString() {
        return "EncryptedValue{value=" + this.value + ", salt=" + this.salt + ", isKeepValue=" + this.isKeepValue + ", isDeleteValue=" + this.isDeleteValue + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EncryptedValue) {
            EncryptedValue that = (EncryptedValue)o;
            return this.value.equals(that.value()) && this.salt.equals(that.salt()) && this.isKeepValue == that.isKeepValue() && this.isDeleteValue == that.isDeleteValue();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.salt.hashCode();
        h$ *= 1000003;
        h$ ^= this.isKeepValue ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.isDeleteValue ? 1231 : 1237;
    }

    static final class Builder
    extends EncryptedValue.Builder {
        private String value;
        private String salt;
        private Boolean isKeepValue;
        private Boolean isDeleteValue;

        Builder() {
        }

        @Override
        public EncryptedValue.Builder value(String value) {
            if (value == null) {
                throw new NullPointerException("Null value");
            }
            this.value = value;
            return this;
        }

        @Override
        public EncryptedValue.Builder salt(String salt) {
            if (salt == null) {
                throw new NullPointerException("Null salt");
            }
            this.salt = salt;
            return this;
        }

        @Override
        public EncryptedValue.Builder isKeepValue(boolean isKeepValue) {
            this.isKeepValue = isKeepValue;
            return this;
        }

        @Override
        public EncryptedValue.Builder isDeleteValue(boolean isDeleteValue) {
            this.isDeleteValue = isDeleteValue;
            return this;
        }

        @Override
        public EncryptedValue build() {
            String missing = "";
            if (this.value == null) {
                missing = missing + " value";
            }
            if (this.salt == null) {
                missing = missing + " salt";
            }
            if (this.isKeepValue == null) {
                missing = missing + " isKeepValue";
            }
            if (this.isDeleteValue == null) {
                missing = missing + " isDeleteValue";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EncryptedValue(this.value, this.salt, this.isKeepValue, this.isDeleteValue);
        }
    }
}

