/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.encryption;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import org.graylog2.security.encryption.AutoValue_EncryptedValue;

@AutoValue
public abstract class EncryptedValue {
    public abstract String value();

    public abstract String salt();

    public abstract boolean isKeepValue();

    public abstract boolean isDeleteValue();

    public boolean isSet() {
        return !Strings.isNullOrEmpty((String)this.value()) && !Strings.isNullOrEmpty((String)this.salt());
    }

    public static EncryptedValue createUnset() {
        return EncryptedValue.builder().value("").salt("").isKeepValue(false).isDeleteValue(false).build();
    }

    public static EncryptedValue createWithKeepValue() {
        return EncryptedValue.builder().value("").salt("").isKeepValue(true).isDeleteValue(false).build();
    }

    public static EncryptedValue createWithDeleteValue() {
        return EncryptedValue.builder().value("").salt("").isKeepValue(false).isDeleteValue(true).build();
    }

    public static Builder builder() {
        return new AutoValue_EncryptedValue.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder value(String var1);

        public abstract Builder salt(String var1);

        public abstract Builder isKeepValue(boolean var1);

        public abstract Builder isDeleteValue(boolean var1);

        public abstract EncryptedValue build();
    }
}

