/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.encryption;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueMapperConfig;
import org.graylog2.security.encryption.EncryptedValueService;

public class EncryptedValueDeserializer
extends StdDeserializer<EncryptedValue> {
    private final EncryptedValueService encryptedValueService;

    public EncryptedValueDeserializer(EncryptedValueService encryptedValueService) {
        super(EncryptedValue.class);
        this.encryptedValueService = encryptedValueService;
    }

    public EncryptedValue getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        return EncryptedValue.createUnset();
    }

    public EncryptedValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (EncryptedValueMapperConfig.isDatabase((DatabindContext)ctxt)) {
            return this.parseFromDatabase(p, node);
        }
        this.validateValue(p, node);
        if (!node.path("keep_value").isMissingNode()) {
            return this.parseKeepValue(p, node);
        }
        if (!node.path("delete_value").isMissingNode()) {
            return this.parseDeleteValue(p, node);
        }
        return this.parseSetValue(p, node);
    }

    private EncryptedValue parseFromDatabase(JsonParser p, JsonNode node) throws JsonProcessingException {
        JsonNode value = node.path("encrypted_value");
        JsonNode salt = node.path("salt");
        if (value.isTextual() && salt.isTextual()) {
            return EncryptedValue.builder().value(value.asText()).salt(salt.asText()).isKeepValue(false).isDeleteValue(false).build();
        }
        throw new JsonMappingException((Closeable)p, "Couldn't deserialize value: " + node.toString() + " (encrypted_value and salt must be a strings and cannot missing)");
    }

    private void validateValue(JsonParser p, JsonNode node) throws JsonMappingException {
        if (node.isTextual()) {
            return;
        }
        long count = Stream.of("keep_value", "delete_value", "set_value").map(arg_0 -> ((JsonNode)node).path(arg_0)).filter(jsonNode -> !jsonNode.isMissingNode()).count();
        if (count > 1L) {
            throw new JsonMappingException((Closeable)p, "Couldn't deserialize value: " + node.toString() + " (keep_value, delete_value and set_value are mutually exclusive)");
        }
    }

    private EncryptedValue parseKeepValue(JsonParser p, JsonNode node) throws JsonProcessingException {
        JsonNode keepValue = node.path("keep_value");
        if (keepValue.isBoolean() && keepValue.booleanValue()) {
            return EncryptedValue.createWithKeepValue();
        }
        throw new JsonMappingException((Closeable)p, "Couldn't deserialize value: " + node.toString() + " (keep_value must be a boolean and true)");
    }

    private EncryptedValue parseDeleteValue(JsonParser p, JsonNode node) throws JsonProcessingException {
        JsonNode deleteValue = node.path("delete_value");
        if (deleteValue.isBoolean() && deleteValue.booleanValue()) {
            return EncryptedValue.createWithDeleteValue();
        }
        throw new JsonMappingException((Closeable)p, "Couldn't deserialize value: " + node.toString() + " (delete_value must be a boolean and true)");
    }

    private EncryptedValue parseSetValue(JsonParser p, JsonNode node) throws JsonProcessingException {
        JsonNode setValue;
        JsonNode jsonNode = setValue = node.isTextual() ? node : node.path("set_value");
        if (setValue.isTextual() && !StringUtils.isBlank((CharSequence)setValue.asText())) {
            return this.encryptedValueService.encrypt(setValue.asText());
        }
        throw new JsonMappingException((Closeable)p, "Couldn't deserialize value: " + node.toString() + " (set_value must be a string and cannot be empty or missing)");
    }
}

