/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.messageq;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.shared.messageq.MessageQueueReader;

public abstract class AbstractMessageQueueReader
extends AbstractExecutionThreadService
implements MessageQueueReader {
    private final EventBus eventBus;
    private volatile boolean shouldBeReading;

    public AbstractMessageQueueReader(EventBus eventBus) {
        this.eventBus = eventBus;
        this.shouldBeReading = false;
    }

    protected void startUp() throws Exception {
        super.startUp();
        this.eventBus.register((Object)this);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
        super.shutDown();
    }

    @Subscribe
    public void listenForLifecycleChanges(Lifecycle lifecycle) {
        switch (lifecycle) {
            case UNINITIALIZED: 
            case STARTING: 
            case PAUSED: 
            case HALTING: {
                this.shouldBeReading = false;
                break;
            }
            case RUNNING: 
            case THROTTLED: {
                this.shouldBeReading = true;
                break;
            }
            case FAILED: {
                this.triggerShutdown();
                break;
            }
        }
    }

    protected boolean shouldBeReading() {
        return this.shouldBeReading;
    }
}

