/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;

public class CORSFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final ImmutableMap<String, Object> CORS_HEADERS = ImmutableMap.of((Object)"Access-Control-Allow-Origin", (Object)"*", (Object)"Access-Control-Allow-Credentials", (Object)true, (Object)"Access-Control-Allow-Headers", (Object)"Authorization, Content-Type, X-Graylog-No-Session-Extension, X-Requested-With, X-Requested-By", (Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS", (Object)"Access-Control-Max-Age", (Object)"600");

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String origin;
        if ("options".equalsIgnoreCase(requestContext.getRequest().getMethod())) {
            if (Response.Status.Family.familyOf((int)responseContext.getStatus()) == Response.Status.Family.SUCCESSFUL) {
                return;
            }
            responseContext.setStatus(Response.Status.NO_CONTENT.getStatusCode());
            responseContext.setEntity((Object)"");
        }
        if ((origin = (String)requestContext.getHeaders().getFirst((Object)"Origin")) != null && !origin.isEmpty()) {
            CORS_HEADERS.forEach((k, v) -> responseContext.getHeaders().add(k, v));
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if ("options".equalsIgnoreCase(requestContext.getRequest().getMethod())) {
            Response.ResponseBuilder options = Response.noContent();
            String origin = (String)requestContext.getHeaders().getFirst((Object)"Origin");
            if (origin != null && !origin.isEmpty()) {
                CORS_HEADERS.forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)options).header(arg_0, arg_1));
                requestContext.abortWith(options.build());
            }
        }
    }
}

