/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog2.shared.security.ActorAwareAuthenticationToken;
import org.graylog2.shared.security.ActorAwareAuthenticationTokenFactory;
import org.graylog2.shared.security.ActorAwareUsernamePasswordToken;

public class ActorAwareUsernamePasswordTokenFactory
implements ActorAwareAuthenticationTokenFactory {
    @Override
    public ActorAwareAuthenticationToken forRequestBody(JsonNode jsonBody) {
        String missingProperties = Stream.of("username", "password").filter(key -> jsonBody.get(key) == null || jsonBody.get(key).asText().isEmpty()).collect(Collectors.joining(", "));
        if (!missingProperties.isEmpty()) {
            throw new IllegalArgumentException("Missing required properties: " + missingProperties + ".");
        }
        String username = jsonBody.get("username").asText();
        String password = jsonBody.get("password").asText();
        return new ActorAwareUsernamePasswordToken(username, password);
    }
}

