/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security.tls;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultTLSProtocolProvider {
    private static final Set<String> SECURE_TLS_PROTOCOLS = ImmutableSet.of((Object)"TLSv1.2", (Object)"TLSv1.3");
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTLSProtocolProvider.class);
    private static Set<String> defaultSupportedTlsProtocols = null;

    public static synchronized Set<String> getSecureTLSProtocols() {
        Set<String> supportedProtocols;
        if (defaultSupportedTlsProtocols != null) {
            return defaultSupportedTlsProtocols;
        }
        HashSet tlsProtocols = Sets.newHashSet(SECURE_TLS_PROTOCOLS);
        if (tlsProtocols.retainAll(supportedProtocols = DefaultTLSProtocolProvider.getAllSupportedTlsProtocols())) {
            LOG.warn("JRE doesn't support all default TLS protocols. Changing <{}> to <{}>", SECURE_TLS_PROTOCOLS, (Object)tlsProtocols);
        }
        defaultSupportedTlsProtocols = tlsProtocols;
        return defaultSupportedTlsProtocols;
    }

    public static Set<String> getAllSupportedTlsProtocols() {
        try {
            return Arrays.stream(SSLContext.getDefault().createSSLEngine().getSupportedProtocols()).filter(p -> !p.equals("SSLv3")).collect(Collectors.toSet());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Failed to detect supported TLS protocols. Keeping default <{}>", SECURE_TLS_PROTOCOLS, (Object)e);
            return SECURE_TLS_PROTOCOLS;
        }
    }
}

