/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats;

import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.shared.utilities.DockerRuntimeDetection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.util.GlobalConfig;

@Singleton
public class OshiService {
    private static final Logger LOG = LoggerFactory.getLogger(OshiService.class);
    private final HardwareAbstractionLayer hal;
    private final OperatingSystem os;

    @Inject
    public OshiService() {
        ArrayList<String> fsTypes = new ArrayList<String>(Arrays.asList(GlobalConfig.get((String)"oshi.pseudo.filesystem.types", (String)"").split(",")));
        fsTypes.add("aufs");
        if (DockerRuntimeDetection.isRunningInsideDocker().booleanValue()) {
            fsTypes.remove("overlay");
        }
        GlobalConfig.set((String)"oshi.pseudo.filesystem.types", (Object)String.join((CharSequence)",", fsTypes));
        SystemInfo systemInfo = new SystemInfo();
        this.hal = systemInfo.getHardware();
        this.os = systemInfo.getOperatingSystem();
        LOG.debug("Successfully loaded OSHI");
    }

    public HardwareAbstractionLayer getHal() {
        return this.hal;
    }

    public OperatingSystem getOs() {
        return this.os;
    }
}

