/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.plugin.Version;
import org.graylog2.storage.ElasticsearchVersion;
import org.graylog2.storage.UnsupportedElasticsearchException;

public class VersionAwareProvider<T>
implements Provider<T> {
    private final Version elasticsearchMajorVersion;
    private final Map<Version, Provider<T>> pluginBindings;

    @Inject
    public VersionAwareProvider(@ElasticsearchVersion Version elasticsearchVersion, Map<Version, Provider<T>> pluginBindings) {
        this.elasticsearchMajorVersion = this.majorVersionFrom(elasticsearchVersion);
        this.pluginBindings = pluginBindings;
    }

    public T get() {
        Provider<T> provider = this.pluginBindings.get(this.elasticsearchMajorVersion);
        if (provider == null) {
            throw new UnsupportedElasticsearchException(this.elasticsearchMajorVersion);
        }
        return (T)provider.get();
    }

    private Version majorVersionFrom(Version version) {
        return Version.from(version.getVersion().getMajorVersion(), 0, 0);
    }
}

