/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage.versionprobe;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Duration;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.graylog2.storage.versionprobe.ErrorResponse;
import org.graylog2.storage.versionprobe.RootResponse;
import org.graylog2.storage.versionprobe.RootRoute;
import org.graylog2.storage.versionprobe.VersionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class VersionProbe {
    private static final Logger LOG = LoggerFactory.getLogger(VersionProbe.class);
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final int connectionAttempts;
    private final Duration delayBetweenAttempts;

    @Inject
    public VersionProbe(ObjectMapper objectMapper, OkHttpClient okHttpClient, @Named(value="elasticsearch_version_probe_attempts") int elasticsearchVersionProbeAttempts, @Named(value="elasticsearch_version_probe_delay") Duration elasticsearchVersionProbeDelay) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.connectionAttempts = elasticsearchVersionProbeAttempts;
        this.delayBetweenAttempts = elasticsearchVersionProbeDelay;
    }

    public Optional<org.graylog2.plugin.Version> probe(Collection<URI> hosts) {
        try {
            return (Optional)RetryerBuilder.newBuilder().retryIfResult(input -> !input.isPresent()).retryIfExceptionOfType(IOException.class).retryIfRuntimeException().withWaitStrategy(WaitStrategies.fixedWait((long)this.delayBetweenAttempts.getQuantity(), (TimeUnit)this.delayBetweenAttempts.getUnit())).withStopStrategy(this.connectionAttempts == 0 ? StopStrategies.neverStop() : StopStrategies.stopAfterAttempt((int)this.connectionAttempts)).build().call(() -> this.probeAllHosts(hosts));
        }
        catch (RetryException | ExecutionException e) {
            LOG.error("Unable to retrieve version from Elasticsearch node: ", e);
            return Optional.empty();
        }
    }

    private Optional<org.graylog2.plugin.Version> probeAllHosts(Collection<URI> hosts) {
        return hosts.stream().map(this::probeSingleHost).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private Optional<org.graylog2.plugin.Version> probeSingleHost(URI host) {
        Retrofit retrofit;
        try {
            retrofit = new Retrofit.Builder().baseUrl(host.toURL()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).client(this.addAuthenticationIfPresent(host, this.okHttpClient)).build();
        }
        catch (MalformedURLException e) {
            LOG.error("Elasticsearch node URL is invalid: " + host.toString(), (Throwable)e);
            return Optional.empty();
        }
        RootRoute root = (RootRoute)retrofit.create(RootRoute.class);
        Converter errorResponseConverter = retrofit.responseBodyConverter(ErrorResponse.class, new Annotation[0]);
        Consumer<ResponseBody> errorLogger = responseBody -> {
            try {
                ErrorResponse errorResponse = (ErrorResponse)errorResponseConverter.convert(responseBody);
                LOG.error("Unable to retrieve version from Elasticsearch node {}:{}: {}", new Object[]{host.getHost(), host.getPort(), errorResponse});
            }
            catch (IOException e) {
                LOG.error("Unable to retrieve version from Elasticsearch node {}:{}: unknown error - an exception occurred while deserializing error response: {}", new Object[]{host.getHost(), host.getPort(), e});
            }
        };
        return this.rootResponse(root, errorLogger).map(RootResponse::version).map(VersionResponse::number).flatMap(this::parseVersion);
    }

    private OkHttpClient addAuthenticationIfPresent(URI host, OkHttpClient okHttpClient) {
        if (Strings.emptyToNull((String)host.getUserInfo()) != null) {
            String[] credentials = host.getUserInfo().split(":");
            String username = credentials[0];
            String password = credentials[1];
            String authToken = Credentials.basic((String)username, (String)password);
            return okHttpClient.newBuilder().addInterceptor(chain -> {
                Request originalRequest = chain.request();
                Request.Builder builder = originalRequest.newBuilder().header("Authorization", authToken);
                Request newRequest = builder.build();
                return chain.proceed(newRequest);
            }).build();
        }
        return okHttpClient;
    }

    private Optional<org.graylog2.plugin.Version> parseVersion(String versionString) {
        try {
            Version version = Version.valueOf((String)versionString);
            return Optional.of(new org.graylog2.plugin.Version(version));
        }
        catch (Exception e) {
            LOG.error("Unable to parse version retrieved from Elasticsearch node: <{}>", (Object)versionString, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<RootResponse> rootResponse(RootRoute rootRoute, Consumer<ResponseBody> errorLogger) {
        try {
            Response response = rootRoute.root().execute();
            if (response.isSuccessful()) {
                return Optional.ofNullable((RootResponse)response.body());
            }
            errorLogger.accept(response.errorBody());
        }
        catch (IOException e) {
            String error = ExceptionUtils.formatMessageCause(e);
            String rootCause = ExceptionUtils.formatMessageCause(ExceptionUtils.getRootCause(e));
            LOG.error("Unable to retrieve version from Elasticsearch node: {} - {}", (Object)error, (Object)rootCause);
            LOG.debug("Complete exception for version probe error: ", (Throwable)e);
        }
        return Optional.empty();
    }
}

