/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.utilities.IpSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservedIpChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ReservedIpChecker.class);
    private static final String[] RESERVED_IPV4_BLOCKS = new String[]{"0.0.0.0/8", "10.0.0.0/8", "100.64.0.0/10", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", "192.0.0.0/24", "192.0.2.0/24", "192.88.99.0/24", "192.168.0.0/16", "198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24", "224.0.0.0/4", "233.252.0.0/24", "240.0.0.0/4", "255.255.255.255/32"};
    private static ReservedIpChecker instance;
    private final List<IpSubnet> ipBlocks = this.loadReservedIpBlocks();

    private List<IpSubnet> loadReservedIpBlocks() {
        return Arrays.stream(RESERVED_IPV4_BLOCKS).map(ReservedIpChecker.stringToSubnet()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.ipBlocks.isEmpty();
    }

    public boolean isReservedIpAddress(String address) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return false;
        }
        return this.ipBlocks.stream().anyMatch(e -> ReservedIpChecker.subnetContainsAddress(e, address));
    }

    private static Function<String, Optional<IpSubnet>> stringToSubnet() {
        return line -> {
            IpSubnet subnet;
            try {
                subnet = new IpSubnet((String)line);
            }
            catch (UnknownHostException ignore) {
                subnet = null;
            }
            return Optional.ofNullable(subnet);
        };
    }

    private static boolean subnetContainsAddress(IpSubnet subnet, String targetAddress) {
        try {
            return subnet.contains(targetAddress);
        }
        catch (UnknownHostException ignore) {
            return false;
        }
    }

    public static synchronized ReservedIpChecker getInstance() {
        if (instance == null) {
            instance = new ReservedIpChecker();
        }
        return instance;
    }
}

