/*
 * Decompiled with CFR 0.152.
 */
package oi.thekraken.grok.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oi.thekraken.grok.api.BooleanConverter;
import oi.thekraken.grok.api.ByteConverter;
import oi.thekraken.grok.api.DateConverter;
import oi.thekraken.grok.api.DoubleConverter;
import oi.thekraken.grok.api.FloatConverter;
import oi.thekraken.grok.api.IConverter;
import oi.thekraken.grok.api.IntegerConverter;
import oi.thekraken.grok.api.KeyValue;
import oi.thekraken.grok.api.LongConverter;
import oi.thekraken.grok.api.ShortConverter;
import oi.thekraken.grok.api.StringConverter;

public class Converter {
    public static Map<String, IConverter<?>> _converters = new HashMap();
    public static Locale locale = Locale.ENGLISH;

    private static IConverter getConverter(String key) throws Exception {
        IConverter<?> converter = _converters.get(key);
        if (converter == null) {
            throw new Exception("Invalid data type :" + key);
        }
        return converter;
    }

    public static KeyValue convert(String key, Object value) {
        String[] spec = key.split(";");
        try {
            if (spec.length == 1) {
                return new KeyValue(spec[0], value);
            }
            if (spec.length == 2) {
                return new KeyValue(spec[0], Converter.getConverter(spec[1]).convert(String.valueOf(value)));
            }
            if (spec.length == 3) {
                return new KeyValue(spec[0], Converter.getConverter(spec[1]).convert(String.valueOf(value), spec[2]));
            }
            return new KeyValue(spec[0], value, "Unsupported spec :" + key);
        }
        catch (Exception e) {
            return new KeyValue(spec[0], value, e.toString());
        }
    }

    static {
        _converters.put("byte", new ByteConverter());
        _converters.put("boolean", new BooleanConverter());
        _converters.put("short", new ShortConverter());
        _converters.put("int", new IntegerConverter());
        _converters.put("long", new LongConverter());
        _converters.put("float", new FloatConverter());
        _converters.put("double", new DoubleConverter());
        _converters.put("date", new DateConverter());
        _converters.put("datetime", new DateConverter());
        _converters.put("string", new StringConverter());
    }
}

