/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zeroio;

import java.io.IOException;
import java.io.PrintStream;
import org.gridkit.zeroio.AbstractLineProcessingOutputStream;
import org.slf4j.Logger;

public class LoggerPrintStream
extends PrintStream {
    public LoggerPrintStream(Logger logger, Level level) {
        super(new StreamStub(logger, level, null));
    }

    public LoggerPrintStream(Logger logger, Level level, String prefix) {
        super(new StreamStub(logger, level, prefix));
    }

    private static final class StreamStub
    extends AbstractLineProcessingOutputStream {
        private final Logger logger;
        private final Level level;
        private final String prefix;

        private StreamStub(Logger logger, Level level, String prefix) {
            level.toString();
            this.logger = logger;
            this.level = level;
            this.prefix = prefix;
        }

        @Override
        protected void processLine(byte[] data) throws IOException {
            if (this.level != Level.NONE) {
                if (this.prefix == null) {
                    this.logLine(new String(data));
                } else {
                    this.logLine(this.prefix + new String(data));
                }
            }
        }

        private void logLine(String text) {
            if (text.length() > 0) {
                if (text.charAt(text.length() - 1) == '\n') {
                    text = text.substring(0, text.length() - 1);
                }
                if (text.charAt(text.length() - 1) == '\r') {
                    text = text.substring(0, text.length() - 1);
                }
                switch (this.level) {
                    case ERROR: {
                        this.logger.error(text);
                        break;
                    }
                    case WARN: {
                        this.logger.warn(text);
                        break;
                    }
                    case INFO: {
                        this.logger.info(text);
                        break;
                    }
                    case DEBUG: {
                        this.logger.debug(text);
                        break;
                    }
                    case TRACE: {
                        this.logger.trace(text);
                    }
                }
            }
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        NONE;

    }
}

