/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.gridkit.zerormi.Box;

class FutureBox<V>
implements Future<V>,
Box<V> {
    private final FutureTask<V> ft = new FutureTask(new Callable<V>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() throws Exception {
            FutureBox futureBox = FutureBox.this;
            synchronized (futureBox) {
                if (!FutureBox.this.finalized) {
                    throw new Error("Unexpected call time");
                }
                if (FutureBox.this.error != null) {
                    throw FutureBox.this.error;
                }
                return FutureBox.this.value;
            }
        }
    });
    private boolean finalized;
    private V value;
    private Exception error;

    FutureBox() {
    }

    @Override
    public synchronized void setData(V data) {
        if (this.finalized) {
            throw new IllegalStateException("Box is closed");
        }
        this.finalized = true;
        this.value = data;
        this.ft.run();
    }

    @Override
    public synchronized void setError(Exception e) {
        if (this.finalized) {
            throw new IllegalStateException("Box is closed");
        }
        this.finalized = true;
        this.error = e;
        this.ft.run();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.ft.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.ft.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.ft.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.ft.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.ft.get(timeout, unit);
    }
}

