/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.gridkit.zerormi.BeanRef;
import org.gridkit.zerormi.Exported;
import org.gridkit.zerormi.FutureBox;
import org.gridkit.zerormi.RemoteCall;
import org.gridkit.zerormi.RemoteInstance;
import org.gridkit.zerormi.RemoteMessage;
import org.gridkit.zerormi.RemoteMethodSignature;
import org.gridkit.zerormi.RemoteRef;
import org.gridkit.zerormi.RemoteReturn;
import org.gridkit.zerormi.RemoteStub;
import org.gridkit.zerormi.RmiChannel;
import org.gridkit.zerormi.RmiMarshaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiChannel1
implements RmiChannel {
    private static final Logger logger = LoggerFactory.getLogger(RmiChannel1.class);
    private static AtomicLong callId = new AtomicLong(0L);
    private final OutputChannel messageOut;
    private final Executor callDispatcher;
    private final Map<Object, RemoteInstance> object2remote = new IdentityHashMap<Object, RemoteInstance>();
    private final Map<RemoteInstance, Object> remote2object = new HashMap<RemoteInstance, Object>();
    private final Map<RemoteInstance, Object> remoteInstanceProxys = new ConcurrentHashMap<RemoteInstance, Object>();
    private final Map<Long, RemoteCallContext> remoteReturnWaiters = new ConcurrentHashMap<Long, RemoteCallContext>();
    private final Map<RemoteMethodSignature, Method> methodCache = new ConcurrentHashMap<RemoteMethodSignature, Method>();
    private final RmiMarshaler marshaler;
    private final Map<String, Object> name2bean = new ConcurrentHashMap<String, Object>();
    private final Map<Object, String> bean2name = new ConcurrentHashMap<Object, String>();
    private volatile boolean terminated = false;

    public RmiChannel1(OutputChannel output, Executor callDispatcher, RmiMarshaler marshaler) {
        this.messageOut = output;
        this.callDispatcher = callDispatcher;
        this.marshaler = marshaler;
    }

    public void registerNamedBean(String name, Object obj) {
        this.name2bean.put(name, obj);
        this.bean2name.put(obj, name);
    }

    @Override
    public void handleMessage(RemoteMessage message) {
        if (message instanceof RemoteCall) {
            final RemoteCall remoteCall = (RemoteCall)message;
            if (remoteCall.getArgs() != null) {
                for (int n = 0; n < remoteCall.getArgs().length; ++n) {
                    Object arg = remoteCall.getArgs()[n];
                    if (!(arg instanceof RemoteInstance)) continue;
                    RemoteInstance remoteInstance = (RemoteInstance)arg;
                    remoteCall.getArgs()[n] = this.getProxyFromRemoteInstance(remoteInstance);
                }
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String threadName = Thread.currentThread().getName();
                    Thread.currentThread().setName("RemoteCall: " + remoteCall.toString());
                    try {
                        RemoteReturn remoteReturn;
                        try {
                            remoteReturn = RmiChannel1.this.delegateCall(remoteCall);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            RmiChannel1.this.close();
                            Thread.currentThread().setName(threadName);
                            return;
                        }
                        try {
                            RmiChannel1.this.sendMessage(remoteReturn);
                        }
                        catch (IOException e) {
                            RmiChannel1.this.close();
                        }
                    }
                    finally {
                        Thread.currentThread().setName(threadName);
                    }
                }
            };
            this.callDispatcher.execute(runnable);
        } else if (message instanceof RemoteReturn) {
            RemoteReturn remoteReturn = (RemoteReturn)message;
            long id = remoteReturn.getCallId();
            RemoteCallContext context = this.remoteReturnWaiters.get(id);
            if (context == null) {
                throw new RuntimeException("Orphaned remote return: " + remoteReturn);
            }
            context.result = remoteReturn;
            LockSupport.unpark(context.thread);
        } else {
            throw new RuntimeException("Unknown RemoteMessage type. " + message);
        }
    }

    @Override
    public synchronized void close() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.object2remote.clear();
        this.remote2object.clear();
        this.remoteInstanceProxys.clear();
        for (RemoteCallContext context : this.remoteReturnWaiters.values()) {
            if (context.result != null) continue;
            context.result = new RemoteReturn(true, new RemoteException("Connection closed"), 0L);
            LockSupport.unpark(context.thread);
        }
        this.remoteReturnWaiters.clear();
    }

    protected void sendMessage(RemoteMessage message) throws IOException {
        this.messageOut.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteReturn delegateCall(RemoteCall remoteCall) {
        RemoteReturn remoteReturn;
        Method implementationMethod;
        Object implementator;
        RemoteInstance instance = remoteCall.getRemoteInstance();
        RemoteMethodSignature methodId = remoteCall.getMethod();
        long callId = remoteCall.getCallId();
        RmiChannel1 rmiChannel1 = this;
        synchronized (rmiChannel1) {
            implementator = this.remote2object.get(remoteCall.getRemoteInstance());
        }
        if (implementator == null) {
            return new RemoteReturn(true, new RemoteException(String.format("Instance %s has not been exported ", instance)), callId);
        }
        try {
            implementationMethod = this.lookupMethod(methodId);
        }
        catch (Exception e) {
            return new RemoteReturn(true, new RemoteException(String.format("Method %s cannot be resolved. %s", methodId, e.toString())), callId);
        }
        Object methodReturn = null;
        try {
            methodReturn = implementationMethod.invoke(implementator, remoteCall.getArgs());
            remoteReturn = new RemoteReturn(false, methodReturn, callId);
        }
        catch (InvocationTargetException e) {
            System.err.println("Call[" + remoteCall + "] exception " + e.getCause().toString());
            remoteReturn = new RemoteReturn(true, e.getCause(), callId);
        }
        catch (Exception e) {
            remoteReturn = new RemoteReturn(true, new RemoteException("Invocation failed", e), callId);
        }
        return remoteReturn;
    }

    private Method lookupMethod(RemoteMethodSignature methodSig) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Method method = this.methodCache.get(methodSig);
        if (method != null) {
            return method;
        }
        Class iface = this.classForName(methodSig.getClassName());
        String methodName = methodSig.getMethodName();
        Class[] argTypes = this.toClassObjects(methodSig.getMethodSignature());
        method = iface.getMethod(methodName, argTypes);
        method.setAccessible(true);
        this.methodCache.put(methodSig, method);
        return method;
    }

    public Long generateCallId() {
        Long id = callId.getAndIncrement();
        if (this.remoteReturnWaiters.containsKey(id)) {
            return this.generateCallId();
        }
        return id;
    }

    protected RemoteCallFuture asyncInvoke(RemoteInstance remoteInstance, Method method, Object[] args) throws Throwable {
        Long id = this.generateCallId();
        RemoteCall remoteCall = new RemoteCall(remoteInstance, new RemoteMethodSignature(method), args, id);
        RemoteCallFuture future = new RemoteCallFuture(remoteCall);
        this.registerCall(future);
        return future;
    }

    private void registerCall(RemoteCallFuture future) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remoteInvocation(RemoteStub stub, Object proxy, Method method, Object[] args) throws Throwable {
        RemoteCallContext context;
        Long id;
        block9: {
            id = this.generateCallId();
            RemoteInstance remoteInstance = stub.getRemoteInstance();
            RemoteCall remoteCall = new RemoteCall(remoteInstance, new RemoteMethodSignature(method), args, id);
            context = new RemoteCallContext(Thread.currentThread());
            if (this.terminated) {
                throw new RemoteException("Connection closed");
            }
            this.remoteReturnWaiters.put(id, context);
            try {
                this.sendMessage(remoteCall);
            }
            catch (IOException e) {
                throw new RemoteException("Call failed", e);
            }
            do {
                RmiChannel1 e = this;
                synchronized (e) {
                    if (this.terminated) {
                        throw new InterruptedException("Terminated");
                    }
                }
                LockSupport.park();
                if (context.result != null) break block9;
                if (!this.terminated) continue;
                throw new RemoteException("Connection closed");
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
        this.remoteReturnWaiters.remove(id);
        RemoteReturn ret = context.result;
        if (ret.throwing) {
            throw (Throwable)ret.getRet();
        }
        return ret.getRet();
    }

    private Object getProxyFromRemoteInstance(RemoteInstance remoteInstance) {
        Object proxy = this.remoteInstanceProxys.get(remoteInstance);
        if (proxy == null) {
            try {
                proxy = RemoteStub.buildProxy(remoteInstance, this);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.remoteInstanceProxys.put(remoteInstance, proxy);
            this.object2remote.put(proxy, remoteInstance);
        }
        return proxy;
    }

    public <T> void exportObject(Class<T> iface, T implementation) {
        this.exportObject(new Class[]{iface}, implementation);
    }

    private synchronized RemoteInstance exportObject(Class[] interfaces, Object obj) {
        RemoteInstance remote = this.object2remote.get(obj);
        if (remote == null) {
            String uuid = UUID.randomUUID().toString();
            String[] ifNames = new String[interfaces.length];
            for (int i = 0; i != ifNames.length; ++i) {
                ifNames[i] = interfaces[i].getName();
            }
            remote = new RemoteInstance(uuid, ifNames);
            this.object2remote.put(obj, remote);
            this.remote2object.put(remote, obj);
        }
        return remote;
    }

    @Override
    public synchronized Object streamResolveObject(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BeanRef) {
            BeanRef ref = (BeanRef)obj;
            Object bean = this.name2bean.get(ref.getBeanName());
            if (bean == null) {
                logger.warn("Cannot resolve bean named '" + ref + "'");
            }
            return bean;
        }
        if (obj instanceof RemoteRef) {
            RemoteRef ref = (RemoteRef)obj;
            if (this.remote2object.containsKey(ref.getIdentity())) {
                return this.remote2object.get(ref.getIdentity());
            }
            return this.getProxyFromRemoteInstance(((RemoteRef)obj).getIdentity());
        }
        return this.marshaler.readResolve(obj);
    }

    @Override
    public synchronized Object streamReplaceObject(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        if (this.bean2name.containsKey(obj)) {
            return new BeanRef(this.bean2name.get(obj));
        }
        RemoteInstance id = this.object2remote.get(obj);
        if (id != null) {
            return new RemoteRef(id);
        }
        Object mr = this.marshaler.writeReplace(obj);
        if (mr instanceof Exported) {
            Exported exp = (Exported)mr;
            return new RemoteRef(this.exportObject(exp.getInterfaces(), exp.getObject()));
        }
        return mr;
    }

    public static String[] toClassNames(Class[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i != classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        return names;
    }

    public Class[] toClassObjects(String[] names) throws ClassNotFoundException {
        Class[] classes = new Class[names.length];
        for (int i = 0; i != names.length; ++i) {
            classes[i] = this.classForName(names[i]);
        }
        return classes;
    }

    @Override
    public Class classForName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    private static class RemoteCallFuture
    extends FutureBox<Object> {
        RemoteCall remoteCall;

        public RemoteCallFuture(RemoteCall remoteCall) {
            this.remoteCall = remoteCall;
        }
    }

    private static class RemoteCallContext {
        public final Thread thread;
        public RemoteReturn result;

        public RemoteCallContext(Thread thread) {
            this.thread = thread;
        }
    }

    public static interface OutputChannel {
        public void send(RemoteMessage var1) throws IOException;
    }
}

