/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gridkit.zerormi.Exported;
import org.gridkit.zerormi.RmiMarshaler;
import org.gridkit.zerormi.SmartAnonMarshaler;

public class SmartRmiMarshaler
implements RmiMarshaler {
    private final Map<Class<?>, Class[]> remoteAutodetectCache = new ConcurrentHashMap();
    private Class[] remoteInterfaceMarkers;

    public SmartRmiMarshaler() {
        this.remoteInterfaceMarkers = new Class[]{Remote.class};
    }

    public SmartRmiMarshaler(Class<?> ... types) {
        this.remoteInterfaceMarkers = types;
    }

    @Override
    public Object writeReplace(Object obj) throws IOException {
        if (obj instanceof Serializable && !Proxy.isProxyClass(obj.getClass())) {
            return obj;
        }
        if (this.isEligbleForExport(obj)) {
            Class<?>[] ifs = this.getRemoteInterfaces(obj);
            return new Exported(obj, ifs);
        }
        return SmartAnonMarshaler.marshal(obj);
    }

    protected boolean isEligbleForExport(Object obj) {
        for (Class marker : this.remoteInterfaceMarkers) {
            if (!marker.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    protected Class<?>[] getRemoteInterfaces(Object obj) throws IOException {
        Class<?> objClass = obj.getClass();
        Class[] result = this.remoteAutodetectCache.get(objClass);
        if (result != null) {
            return result;
        }
        result = this.detectRemoteInterfaces(objClass);
        this.remoteAutodetectCache.put(objClass, result);
        return result;
    }

    private Class<?>[] detectRemoteInterfaces(Class<?> objClass) throws IOException {
        ArrayList<Class> iflist = new ArrayList<Class>();
        iflist.addAll(Arrays.asList(objClass.getInterfaces()));
        Iterator it = iflist.iterator();
        while (it.hasNext()) {
            Class intf = (Class)it.next();
            if (!this.isRemoteInterface(intf)) {
                it.remove();
                continue;
            }
            for (Class other : iflist) {
                if (intf == other || !intf.isAssignableFrom(other)) continue;
                it.remove();
            }
        }
        if (iflist.isEmpty()) {
            for (Class<?> intf : objClass.getInterfaces()) {
                if (this.isRemoteInterface(intf)) continue;
                iflist.add(intf);
            }
            this.reduceSuperTypes(iflist);
        }
        if (iflist.isEmpty()) {
            throw new IOException("Cannot calculate remote interface for class " + objClass.getName());
        }
        Class[] result = iflist.toArray(new Class[iflist.size()]);
        return result;
    }

    private void reduceSuperTypes(List<Class> iflist) {
        Iterator<Class> it = iflist.iterator();
        while (it.hasNext()) {
            Class intf = it.next();
            for (Class other : iflist) {
                if (intf == other || !intf.isAssignableFrom(other)) continue;
                it.remove();
            }
        }
    }

    private boolean isRemoteInterface(Class intf) {
        boolean remote = false;
        for (Class marker : this.remoteInterfaceMarkers) {
            if (!marker.isAssignableFrom(intf)) continue;
            remote = true;
            break;
        }
        return remote;
    }

    @Override
    public Object readResolve(Object obj) throws IOException {
        if (obj instanceof SmartAnonMarshaler.AnonEnvelop) {
            return ((SmartAnonMarshaler.AnonEnvelop)obj).unmarshal();
        }
        return obj;
    }
}

