/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi.hub;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.gridkit.zerormi.DuplexStream;
import org.gridkit.zerormi.RmiGateway;
import org.gridkit.zerormi.SocketStream;
import org.gridkit.zerormi.hub.Ping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingEndPoint
implements Runnable,
RmiGateway.StreamErrorHandler {
    public static final String HEARTBEAT_PERIOD = "org.gridkit.telecontrol.slave.heart-beat-period";
    public static final String HEARTBEAT_TIMEOUT = "org.gridkit.telecontrol.slave.heart-beat-timeout";
    private static final Logger LOGGER = LoggerFactory.getLogger(RemotingEndPoint.class);
    private String uid;
    private SocketAddress addr;
    private RmiGateway gateway;
    private long pingInterval = Long.valueOf(System.getProperty("org.gridkit.telecontrol.slave.heart-beat-period", "1000"));
    private long heartBeatTimeout = Long.valueOf(System.getProperty("org.gridkit.telecontrol.slave.heart-beat-timeout", "60000"));
    private Object pingSingnal = new Object();
    private long lastHeartBeat = System.nanoTime();

    public RemotingEndPoint(String uid, SocketAddress addr) {
        this.uid = uid;
        this.addr = addr;
        this.gateway = new RmiGateway("master");
        this.gateway.setStreamErrorHandler(this);
    }

    public void enableHeartbeatDeatchWatch() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Thread.currentThread().setName("HeatbeatDethWatch-" + SimpleDateFormat.getDateTimeInstance().format(new Date()));
                    long stale = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - RemotingEndPoint.this.lastHeartBeat);
                    if (stale > RemotingEndPoint.this.heartBeatTimeout) {
                        System.err.println("Terminating process due to heartbeat timeout");
                        Runtime.getRuntime().halt(0);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        t.setDaemon(true);
        t.setName("HeatbeatDethWatch");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            try {
                Object sock;
                if (!this.gateway.isConnected()) {
                    LOGGER.info("Connecting to master socket");
                    sock = new Socket();
                    try {
                        ((Socket)sock).connect(this.addr);
                    }
                    catch (IOException e) {
                        LOGGER.error("Connection has failed", (Object)this.addr);
                        return;
                    }
                    byte[] magic = this.uid.getBytes();
                    ((Socket)sock).getOutputStream().write(magic);
                    ((Socket)sock).getOutputStream().flush();
                    LOGGER.debug("Master socket connected");
                    SocketStream ss = new SocketStream((Socket)sock);
                    this.gateway.connect(ss);
                    LOGGER.debug("Gateway connected");
                }
                sock = this.pingSingnal;
                synchronized (sock) {
                    this.pingSingnal.wait(this.pingInterval);
                }
                LOGGER.trace("Ping");
                try {
                    this.gateway.getRemoteExecutorService().submit(new Ping()).get();
                    this.lastHeartBeat = System.nanoTime();
                }
                catch (RejectedExecutionException e) {
                    break;
                }
                catch (ExecutionException e) {
                    if (!this.gateway.isConnected()) break;
                    LOGGER.warn("Ping failed: " + e.getCause().toString());
                }
            }
            catch (Exception e) {
                LOGGER.error("Communication error", (Throwable)e);
            }
        }
        LOGGER.info("Slave has been discontinued");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamError(DuplexStream socket, Object stream, Exception error) {
        LOGGER.warn("Slave read error: " + error.toString());
        Object object = this.pingSingnal;
        synchronized (object) {
            this.pingSingnal.notifyAll();
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Stream error " + socket, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamClosed(DuplexStream socket, Object stream) {
        Object object = this.pingSingnal;
        synchronized (object) {
            this.pingSingnal.notifyAll();
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Stream error " + socket, (Throwable)e);
        }
    }
}

