/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssEval;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.BiMap;
import com.google.gwt.thirdparty.guava.common.collect.HashBiMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DefCollectorVisitor
extends CssVisitor {
    private static final Pattern INVALID_CHAR = Pattern.compile("[^A-Z0-9_]");
    private int renamingCounter = 0;
    private final BiMap<String, String> defMapping;
    private final List<CssDef> constantNodes;
    private final boolean lenient;
    private final TreeLogger treeLogger;

    public DefCollectorVisitor(boolean lenient, TreeLogger treeLogger) {
        this.lenient = lenient;
        this.treeLogger = treeLogger;
        this.defMapping = HashBiMap.create();
        this.constantNodes = new LinkedList<CssDef>();
    }

    public Map<String, String> getDefMapping() {
        return this.defMapping;
    }

    public List<CssDef> getConstantNodes() {
        return this.constantNodes;
    }

    @Override
    public boolean visit(CssEval x, Context ctx) {
        return this.handleDefNode(x);
    }

    @Override
    public boolean visit(CssDef x, Context ctx) {
        return this.handleDefNode(x);
    }

    @Override
    public boolean visit(CssUrl x, Context ctx) {
        return this.handleDefNode(x);
    }

    private boolean handleDefNode(CssDef def) {
        this.constantNodes.add(def);
        if (!this.defMapping.containsKey(def.getKey())) {
            String upperCaseName = this.toUpperCase(def.getKey());
            String validName = INVALID_CHAR.matcher(upperCaseName).replaceAll("_");
            if (!validName.equals(upperCaseName)) {
                this.treeLogger.log(TreeLogger.Type.WARN, "Invalid characters detected in [" + upperCaseName + "]. They have been replaced [" + validName + "]");
            }
            if (this.defMapping.containsValue(validName)) {
                if (this.lenient) {
                    this.treeLogger.log(TreeLogger.Type.WARN, "Two constants have the same name [" + validName + "] after conversion. The second constant will be renamed automatically.");
                    validName = this.renameConstant(validName);
                } else {
                    throw new Css2GssConversionException("Two constants have the same name [" + validName + "] after conversion.");
                }
            }
            this.defMapping.forcePut(def.getKey(), validName);
        }
        return false;
    }

    private String renameConstant(String originalName) {
        String newName;
        do {
            newName = originalName + "__RENAMED__" + this.renamingCounter;
            ++this.renamingCounter;
        } while (this.defMapping.containsValue(newName));
        return newName;
    }

    private String toUpperCase(String camelCase) {
        assert (!Strings.isNullOrEmpty(camelCase)) : "camelCase cannot be null or empty";
        if (this.isUpperCase(camelCase)) {
            return camelCase;
        }
        StringBuilder output = new StringBuilder().append(Character.toUpperCase(camelCase.charAt(0)));
        for (int i = 1; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                output.append('_').append(c);
                continue;
            }
            output.append(Character.toUpperCase(c));
        }
        return output.toString();
    }

    private boolean isUpperCase(String camelCase) {
        for (int i = 0; i < camelCase.length(); ++i) {
            if (!Character.isLowerCase(camelCase.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

