/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.application.ApplicationHDIV;
import org.hdiv.application.IApplication;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.StartPage;
import org.hdiv.config.annotation.ExclusionRegistry;
import org.hdiv.config.annotation.LongLivingPagesRegistry;
import org.hdiv.config.annotation.RuleRegistry;
import org.hdiv.config.annotation.ValidationConfigurer;
import org.hdiv.config.annotation.builders.SecurityConfigBuilder;
import org.hdiv.config.validations.DefaultValidationParser;
import org.hdiv.context.RequestContextFactory;
import org.hdiv.context.RequestContextFactoryImpl;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataValidator.DataValidator;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.dataValidator.ValidationResult;
import org.hdiv.filter.DefaultValidationContextFactory;
import org.hdiv.filter.DefaultValidatorErrorHandler;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.ValidationContextFactory;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.filter.ValidatorHelperRequest;
import org.hdiv.idGenerator.PageIdGenerator;
import org.hdiv.idGenerator.RandomGuidUidGenerator;
import org.hdiv.idGenerator.SequentialPageIdGenerator;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.init.DefaultRequestInitializer;
import org.hdiv.init.DefaultServletContextInitializer;
import org.hdiv.init.DefaultSessionInitializer;
import org.hdiv.init.RequestInitializer;
import org.hdiv.init.ServletContextInitializer;
import org.hdiv.init.SessionInitializer;
import org.hdiv.logs.IUserData;
import org.hdiv.logs.Logger;
import org.hdiv.logs.UserData;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.session.ISession;
import org.hdiv.session.IStateCache;
import org.hdiv.session.SessionHDIV;
import org.hdiv.session.StateCache;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.AppStateScope;
import org.hdiv.state.scope.DefaultStateScopeManager;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.state.scope.UserSessionStateScope;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.validator.DefaultEditableDataValidationProvider;
import org.hdiv.validator.DefaultValidationRepository;
import org.hdiv.validator.EditableDataValidationProvider;
import org.hdiv.validator.IValidation;
import org.hdiv.validator.Validation;
import org.hdiv.validator.ValidationRepository;
import org.hdiv.validator.ValidationTarget;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHdivWebSecurityConfiguration {
    protected void configure(SecurityConfigBuilder securityConfigBuilder) {
    }

    protected void addExclusions(ExclusionRegistry registry) {
    }

    protected void addLongLivingPages(LongLivingPagesRegistry registry) {
    }

    protected void addRules(RuleRegistry registry) {
    }

    protected void configureEditableValidation(ValidationConfigurer validationConfigurer) {
    }

    @Bean
    public HDIVConfig hdivConfig() {
        SecurityConfigBuilder securityConfigBuilder = this.securityConfigBuilder();
        this.configure(securityConfigBuilder);
        HDIVConfig config = securityConfigBuilder.build();
        config.setEditableDataValidationProvider(this.editableDataValidationProvider());
        ExclusionRegistry exclusionRegistry = new ExclusionRegistry(this.patternMatcherFactory());
        this.addExclusions(exclusionRegistry);
        List<StartPage> exclusions = exclusionRegistry.getUrlExclusions();
        config.setUserStartPages(exclusions);
        List<String> paramExclusions = exclusionRegistry.getParamExclusions();
        config.setUserStartParameters(paramExclusions);
        Map<String, List<String>> paramsWithoutValidation = exclusionRegistry.getParamExclusionsForUrl();
        config.setParamsWithoutValidation(paramsWithoutValidation);
        LongLivingPagesRegistry longLivingPagesRegistry = new LongLivingPagesRegistry();
        this.addLongLivingPages(longLivingPagesRegistry);
        Map<String, String> longLivingPages = longLivingPagesRegistry.getLongLivingPages();
        config.setLongLivingPages(longLivingPages);
        return config;
    }

    @Bean
    public RequestContextFactory requestContextFactory() {
        return new RequestContextFactoryImpl();
    }

    @Bean
    protected SecurityConfigBuilder securityConfigBuilder() {
        return new SecurityConfigBuilder(this.patternMatcherFactory());
    }

    @Bean
    public IApplication securityApplication() {
        return new ApplicationHDIV();
    }

    @Bean
    public ValidationResult validationResult() {
        return new ValidationResult();
    }

    @Bean
    public PatternMatcherFactory patternMatcherFactory() {
        return new PatternMatcherFactory();
    }

    @Bean
    public UidGenerator uidGenerator() {
        return new RandomGuidUidGenerator();
    }

    @Bean
    @Scope(value="prototype")
    public PageIdGenerator pageIdGenerator() {
        return new SequentialPageIdGenerator();
    }

    @Bean
    public IUserData securityUserData() {
        return new UserData();
    }

    @Bean
    public Logger securityLogger() {
        return new Logger();
    }

    @Bean
    public ValidatorErrorHandler validatorErrorHandler() {
        DefaultValidatorErrorHandler validatorErrorHandler = new DefaultValidatorErrorHandler();
        validatorErrorHandler.setConfig(this.hdivConfig());
        return validatorErrorHandler;
    }

    @Bean
    @Scope(value="prototype")
    public IStateCache stateCache() {
        SecurityConfigBuilder builder = this.securityConfigBuilder();
        int maxPagesPerSession = builder.getMaxPagesPerSession();
        StateCache stateCache = new StateCache();
        if (maxPagesPerSession > 0) {
            stateCache.setMaxSize(maxPagesPerSession);
        }
        return stateCache;
    }

    @Bean
    public ISession securitySession() {
        return new SessionHDIV();
    }

    @Bean
    public StateUtil stateUtil() {
        StateUtil stateUtil = new StateUtil();
        stateUtil.setConfig(this.hdivConfig());
        stateUtil.setSession(this.securitySession());
        stateUtil.setStateScopeManager(this.stateScopeManager());
        stateUtil.init();
        return stateUtil;
    }

    @Bean
    public IDataValidator dataValidator() {
        DataValidator dataValidator = new DataValidator();
        dataValidator.setConfig(this.hdivConfig());
        return dataValidator;
    }

    @Bean
    public StateScopeManager stateScopeManager() {
        ArrayList<Object> stateScopes = new ArrayList<Object>();
        stateScopes.add(this.userSessionStateScope());
        stateScopes.add(this.appStateScope());
        return new DefaultStateScopeManager(stateScopes);
    }

    @Bean
    public UserSessionStateScope userSessionStateScope() {
        UserSessionStateScope scope = new UserSessionStateScope();
        scope.setSession(this.securitySession());
        return scope;
    }

    @Bean
    public AppStateScope appStateScope() {
        return new AppStateScope();
    }

    @Bean
    public DataComposerFactory dataComposerFactory() {
        DataComposerFactory dataComposerFactory = new DataComposerFactory();
        dataComposerFactory.setConfig(this.hdivConfig());
        dataComposerFactory.setSession(this.securitySession());
        dataComposerFactory.setStateUtil(this.stateUtil());
        dataComposerFactory.setUidGenerator(this.uidGenerator());
        dataComposerFactory.setStateScopeManager(this.stateScopeManager());
        return dataComposerFactory;
    }

    @Bean
    public IValidationHelper requestValidationHelper() {
        ValidatorHelperRequest validatorHelperRequest = new ValidatorHelperRequest();
        validatorHelperRequest.setStateUtil(this.stateUtil());
        validatorHelperRequest.setHdivConfig(this.hdivConfig());
        validatorHelperRequest.setSession(this.securitySession());
        validatorHelperRequest.setDataValidator(this.dataValidator());
        validatorHelperRequest.setUrlProcessor(this.basicUrlProcessor());
        validatorHelperRequest.setDataComposerFactory(this.dataComposerFactory());
        validatorHelperRequest.setStateScopeManager(this.stateScopeManager());
        validatorHelperRequest.init();
        return validatorHelperRequest;
    }

    @Bean
    public RequestInitializer securityRequestInitializer() {
        DefaultRequestInitializer requestInitializer = new DefaultRequestInitializer();
        requestInitializer.setConfig(this.hdivConfig());
        requestInitializer.setSession(this.securitySession());
        return requestInitializer;
    }

    @Bean
    public ServletContextInitializer securityServletContextInitializer() {
        DefaultServletContextInitializer servletContextInitializer = new DefaultServletContextInitializer();
        servletContextInitializer.setConfig(this.hdivConfig());
        servletContextInitializer.setApplication(this.securityApplication());
        servletContextInitializer.setFormUrlProcessor(this.formUrlProcessor());
        servletContextInitializer.setLinkUrlProcessor(this.linkUrlProcessor());
        return servletContextInitializer;
    }

    @Bean
    public SessionInitializer securitySessionInitializer() {
        DefaultSessionInitializer sessionInitializer = new DefaultSessionInitializer();
        sessionInitializer.setConfig(this.hdivConfig());
        return sessionInitializer;
    }

    @Bean
    public LinkUrlProcessor linkUrlProcessor() {
        LinkUrlProcessor linkUrlProcessor = new LinkUrlProcessor();
        linkUrlProcessor.setConfig(this.hdivConfig());
        return linkUrlProcessor;
    }

    @Bean
    public FormUrlProcessor formUrlProcessor() {
        FormUrlProcessor formUrlProcessor = new FormUrlProcessor();
        formUrlProcessor.setConfig(this.hdivConfig());
        return formUrlProcessor;
    }

    @Bean
    public BasicUrlProcessor basicUrlProcessor() {
        BasicUrlProcessor basicUrlProcessor = new BasicUrlProcessor();
        basicUrlProcessor.setConfig(this.hdivConfig());
        return basicUrlProcessor;
    }

    @Bean
    public EditableDataValidationProvider editableDataValidationProvider() {
        DefaultEditableDataValidationProvider provider = new DefaultEditableDataValidationProvider();
        provider.setValidationRepository(this.editableValidationRepository());
        return provider;
    }

    @Bean
    public ValidationRepository editableValidationRepository() {
        List<IValidation> defaultRules = this.getDefaultRules();
        Map<String, IValidation> customRules = this.getCustomRules();
        Map<ValidationTarget, List<IValidation>> validationsData = this.getValidationsData(defaultRules, customRules);
        DefaultValidationRepository repository = new DefaultValidationRepository();
        repository.setValidations(validationsData);
        repository.setDefaultValidations(defaultRules);
        return repository;
    }

    @Bean
    public ValidationContextFactory validationContextFactory() {
        return new DefaultValidationContextFactory();
    }

    protected List<IValidation> getDefaultRules() {
        DefaultValidationParser parser = new DefaultValidationParser();
        parser.readDefaultValidations();
        List<Map<DefaultValidationParser.ValidationParam, String>> validations = parser.getValidations();
        ArrayList<IValidation> defaultRules = new ArrayList<IValidation>();
        for (Map<DefaultValidationParser.ValidationParam, String> validation : validations) {
            String id = validation.get((Object)DefaultValidationParser.ValidationParam.ID);
            String regex = validation.get((Object)DefaultValidationParser.ValidationParam.REGEX);
            Validation validationBean = new Validation();
            validationBean.setName(id);
            validationBean.setDefaultValidation(true);
            validationBean.setRejectedPattern(regex);
            defaultRules.add((IValidation)validationBean);
        }
        return defaultRules;
    }

    protected Map<String, IValidation> getCustomRules() {
        RuleRegistry registry = new RuleRegistry();
        this.addRules(registry);
        return registry.getRules();
    }

    protected Map<ValidationTarget, List<IValidation>> getValidationsData(List<IValidation> defaultRules, Map<String, IValidation> customRules) {
        PatternMatcherFactory patternMatcherFactory = this.patternMatcherFactory();
        ValidationConfigurer validationConfigurer = new ValidationConfigurer();
        this.configureEditableValidation(validationConfigurer);
        List<ValidationConfigurer.ValidationConfig> validationConfigs = validationConfigurer.getValidationConfigs();
        LinkedHashMap<ValidationTarget, List<IValidation>> validationsData = new LinkedHashMap<ValidationTarget, List<IValidation>>();
        for (ValidationConfigurer.ValidationConfig validationConfig : validationConfigs) {
            String urlPattern = validationConfig.getUrlPattern();
            ValidationConfigurer.ValidationConfig.EditableValidationConfigurer editableValidationConfigurer = validationConfig.getEditableValidationConfigurer();
            boolean useDefaultRules = editableValidationConfigurer.isDefaultRules();
            List<String> selectedRules = editableValidationConfigurer.getRules();
            List<String> selectedParams = editableValidationConfigurer.getParameters();
            ArrayList<IValidation> activeRules = new ArrayList<IValidation>();
            for (String ruleName : selectedRules) {
                IValidation val = customRules.get(ruleName);
                if (val == null) {
                    throw new BeanInitializationException("Rule with name '" + ruleName + "' not registered.");
                }
                activeRules.add(val);
            }
            if (useDefaultRules) {
                activeRules.addAll(defaultRules);
            }
            ValidationTarget target = new ValidationTarget();
            if (urlPattern != null) {
                PatternMatcher urlMatcher = patternMatcherFactory.getPatternMatcher(urlPattern);
                target.setUrl(urlMatcher);
            }
            ArrayList<PatternMatcher> paramMatchers = new ArrayList<PatternMatcher>();
            for (String param : selectedParams) {
                PatternMatcher matcher = patternMatcherFactory.getPatternMatcher(param);
                paramMatchers.add(matcher);
            }
            target.setParams(paramMatchers);
            validationsData.put(target, activeRules);
        }
        return validationsData;
    }
}

