/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.jsf;

import org.hdiv.components.support.OutcomeTargetComponentProcessor;
import org.hdiv.components.support.OutputLinkComponentProcessor;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.annotation.condition.ConditionalOnFramework;
import org.hdiv.config.annotation.condition.SupportedFramework;
import org.hdiv.config.multipart.JsfMultipartConfig;
import org.hdiv.context.RedirectHelper;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.JsfValidatorErrorHandler;
import org.hdiv.filter.JsfValidatorHelper;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.session.ISession;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.validation.DefaultComponentTreeValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnFramework(value=SupportedFramework.JSF)
public class JsfConfigurationSupport {
    @Autowired
    protected StateUtil stateUtil;
    @Autowired
    protected HDIVConfig config;
    @Autowired
    protected ISession session;
    @Autowired
    protected IDataValidator dataValidator;
    @Autowired
    protected BasicUrlProcessor basicUrlProcessor;
    @Autowired
    protected DataComposerFactory dataComposerFactory;
    @Autowired
    protected LinkUrlProcessor linkUrlProcessor;
    @Autowired
    protected StateScopeManager stateScopeManager;

    @Bean
    @Primary
    public ValidatorErrorHandler validatorErrorHandler() {
        JsfValidatorErrorHandler validatorErrorHandler = new JsfValidatorErrorHandler();
        validatorErrorHandler.setConfig(this.config);
        return validatorErrorHandler;
    }

    @Bean
    @Primary
    public IValidationHelper jsfValidatorHelper() {
        JsfValidatorHelper validatorHelperRequest = new JsfValidatorHelper();
        validatorHelperRequest.setStateUtil(this.stateUtil);
        validatorHelperRequest.setHdivConfig(this.config);
        validatorHelperRequest.setSession(this.session);
        validatorHelperRequest.setDataValidator(this.dataValidator);
        validatorHelperRequest.setUrlProcessor(this.basicUrlProcessor);
        validatorHelperRequest.setDataComposerFactory(this.dataComposerFactory);
        validatorHelperRequest.setStateScopeManager(this.stateScopeManager);
        validatorHelperRequest.init();
        return validatorHelperRequest;
    }

    @Bean
    public DefaultComponentTreeValidator componentTreeValidator() {
        DefaultComponentTreeValidator componentTreeValidator = new DefaultComponentTreeValidator();
        componentTreeValidator.setConfig(this.config);
        componentTreeValidator.createComponentValidators();
        return componentTreeValidator;
    }

    @Bean
    public RedirectHelper redirectHelper() {
        RedirectHelper redirectHelper = new RedirectHelper();
        redirectHelper.setLinkUrlProcessor(this.linkUrlProcessor);
        return redirectHelper;
    }

    @Bean
    public JsfMultipartConfig jsfMultipartConfig() {
        return new JsfMultipartConfig();
    }

    @Bean
    public OutcomeTargetComponentProcessor outcomeTargetComponentProcessor() {
        OutcomeTargetComponentProcessor processor = new OutcomeTargetComponentProcessor();
        processor.setConfig(this.config);
        processor.setLinkUrlProcessor(this.linkUrlProcessor);
        return processor;
    }

    @Bean
    public OutputLinkComponentProcessor outputLinkComponentProcessor() {
        OutputLinkComponentProcessor processor = new OutputLinkComponentProcessor();
        processor.setConfig(this.config);
        processor.setLinkUrlProcessor(this.linkUrlProcessor);
        return processor;
    }
}

