/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.factory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.validator.DefaultValidationRepository;
import org.hdiv.validator.IValidation;
import org.hdiv.validator.ValidationTarget;
import org.springframework.beans.factory.config.AbstractFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRepositoryFactoryBean
extends AbstractFactoryBean<DefaultValidationRepository> {
    protected PatternMatcherFactory patternMatcherFactory;
    protected Map<ValidationTargetData, List<String>> validationsData;
    protected List<IValidation> defaultValidations;

    public Class<?> getObjectType() {
        return DefaultValidationRepository.class;
    }

    protected DefaultValidationRepository createInstance() throws Exception {
        DefaultValidationRepository repository = new DefaultValidationRepository();
        LinkedHashMap<ValidationTarget, List<IValidation>> vals = new LinkedHashMap<ValidationTarget, List<IValidation>>();
        for (Map.Entry<ValidationTargetData, List<String>> entry : this.validationsData.entrySet()) {
            ValidationTarget target = new ValidationTarget();
            ValidationTargetData data = entry.getKey();
            List<String> ids = entry.getValue();
            if (data.getUrl() != null) {
                PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(data.getUrl());
                target.setUrl(matcher);
            }
            if (data.getParams() != null && !data.getParams().isEmpty()) {
                List<String> params = data.getParams();
                ArrayList<PatternMatcher> matchers = new ArrayList<PatternMatcher>();
                for (String param : params) {
                    PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(param);
                    matchers.add(matcher);
                }
                target.setParams(matchers);
            }
            vals.put(target, this.createValidationList(ids));
        }
        repository.setValidations(vals);
        repository.setDefaultValidations(this.defaultValidations);
        return repository;
    }

    protected List<IValidation> createValidationList(List<String> ids) {
        ArrayList<IValidation> newList = new ArrayList<IValidation>();
        for (String id : ids) {
            Object bean = this.getBeanFactory().getBean(id);
            if (bean instanceof IValidation) {
                IValidation validation = (IValidation)bean;
                newList.add(validation);
                continue;
            }
            if (!(bean instanceof List)) continue;
            List validations = (List)bean;
            newList.addAll(validations);
        }
        return newList;
    }

    public void setPatternMatcherFactory(PatternMatcherFactory patternMatcherFactory) {
        this.patternMatcherFactory = patternMatcherFactory;
    }

    public void setValidationsData(Map<ValidationTargetData, List<String>> validationsData) {
        this.validationsData = validationsData;
    }

    public void setDefaultValidations(List<IValidation> defaultValidations) {
        this.defaultValidations = defaultValidations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidationTargetData
    implements Serializable {
        private static final long serialVersionUID = 4991119416021943596L;
        private String url;
        private List<String> params;

        public String getUrl() {
            return this.url;
        }

        public List<String> getParams() {
            return this.params;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setParams(List<String> params) {
            this.params = params;
        }
    }
}

