/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.driver.Assignment;
import org.helenus.driver.BindMarker;
import org.helenus.driver.codecs.ArgumentsCodec;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.EmptyOptionalPrimaryKeyException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.DataType;

public abstract class AssignmentImpl
extends Utils.Appendeable
implements Assignment {
    protected final CharSequence name;

    AssignmentImpl(CharSequence name) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        this.name = name;
    }

    CharSequence getColumnName() {
        return this.name;
    }

    abstract boolean isIdempotent();

    abstract void validate(TableInfoImpl<?> var1);

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true);
    }

    static class MapPutAssignmentImpl
    extends AssignmentImpl {
        private final Object key;
        private final Object value;

        MapPutAssignmentImpl(CharSequence name, Object key, Object value) {
            super(name);
            this.key = key;
            this.value = value;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            Utils.appendName(tinfo, null, codecRegistry, sb, this.name).append('[');
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendValue(finfo.getDataType().getFirstArgumentType(), codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0), codecRegistry, sb, this.key, variables);
            sb.append("]=");
            Utils.appendValue(finfo.getDataType().getElementType(), codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(1), codecRegistry, sb, this.value, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.key) || Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return true;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateMapColumnAndKeyValue(this.name, this.key, this.value);
        }
    }

    static class CollectionAssignmentImpl
    extends AssignmentImpl {
        private final DataType ctype;
        private final Object collection;
        private final boolean isAdd;
        private final boolean isIdempotent;

        CollectionAssignmentImpl(DataType ctype, CharSequence name, Object collection, boolean isAdd, boolean isIdempotent) {
            super(name);
            this.ctype = ctype;
            this.collection = collection;
            this.isAdd = isAdd;
            this.isIdempotent = isIdempotent;
        }

        CollectionAssignmentImpl(DataType ctype, CharSequence name, Object collection, boolean isAdd) {
            this(ctype, name, collection, isAdd, true);
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            StringBuilder nsb = new StringBuilder(80);
            Utils.appendName(tinfo, null, codecRegistry, nsb, this.name);
            sb.append((CharSequence)nsb).append('=').append((CharSequence)nsb).append(this.isAdd ? (char)'+' : '-');
            Utils.appendValue(finfo.getDataType(), codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, sb, this.collection, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.collection);
        }

        @Override
        boolean isIdempotent() {
            return this.isIdempotent;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            if (this.ctype == DataType.MAP || this.ctype == DataType.SORTED_MAP) {
                table.validateMapColumnAndKeyValues(this.name, (Map)this.collection);
            } else {
                FieldInfoImpl<?> finfo = table.getColumnImpl(this.name);
                if (finfo != null && (finfo.getDataType().getMainType() == DataType.MAP || finfo.getDataType().getMainType() == DataType.SORTED_MAP)) {
                    table.validateMapColumnAndKeys(this.name, (Iterable)this.collection);
                } else if (this.ctype == DataType.SET || this.ctype == DataType.ORDERED_SET || this.ctype == DataType.SORTED_SET) {
                    table.validateSetColumnAndValues(this.name, (Iterable)this.collection);
                } else {
                    table.validateListColumnAndValues(this.name, (Iterable)this.collection);
                }
            }
        }
    }

    static class ListSetIdxAssignmentImpl
    extends AssignmentImpl {
        private final int idx;
        private final Object value;

        ListSetIdxAssignmentImpl(CharSequence name, int idx, Object value) {
            super(name);
            this.idx = idx;
            this.value = value;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            Utils.appendName(tinfo, null, codecRegistry, sb, this.name).append('[').append(this.idx).append("]=");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendValue(finfo.getDataType().getElementType(), codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0), codecRegistry, sb, this.value, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return true;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateListColumnAndValue(this.name, this.value);
        }
    }

    static class ListPrependAssignmentImpl
    extends AssignmentImpl {
        private final Object value;

        ListPrependAssignmentImpl(CharSequence name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            StringBuilder nsb = new StringBuilder(80);
            Utils.appendName(tinfo, null, codecRegistry, nsb, this.name);
            sb.append((CharSequence)nsb).append('=');
            Utils.appendList(finfo.getDataType(), codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, sb, (List)this.value, variables);
            sb.append('+').append((CharSequence)nsb);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return false;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateListColumnAndValue(this.name, this.value);
        }
    }

    static class CounterAssignmentImpl
    extends AssignmentImpl {
        private final Object value;
        private final boolean isIncr;

        CounterAssignmentImpl(CharSequence name, long value, boolean isIncr) {
            super(name);
            if (!isIncr && value < 0L) {
                this.value = -value;
                this.isIncr = true;
            } else {
                this.value = value;
                this.isIncr = isIncr;
            }
        }

        CounterAssignmentImpl(CharSequence name, BindMarker marker, boolean isIncr) {
            super(name);
            this.value = marker;
            this.isIncr = isIncr;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            StringBuilder nsb = new StringBuilder(80);
            Utils.appendName(tinfo, null, codecRegistry, nsb, this.name);
            sb.append((CharSequence)nsb).append('=').append((CharSequence)nsb).append(this.isIncr ? (char)'+' : '-');
            Utils.appendValue(finfo.getDataType(), codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, sb, this.value, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return false;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateCounterColumn(this.name);
        }
    }

    static class DelayedSetAllAssignmentImpl
    extends AssignmentImpl
    implements DelayedWithObject {
        final Object object;

        DelayedSetAllAssignmentImpl() {
            this((Object)null);
        }

        DelayedSetAllAssignmentImpl(Object object) {
            super("");
            this.object = object;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> table, ClassInfoImpl.POJOContext context) {
            ArrayList<AssignmentImpl> assignments = new ArrayList<AssignmentImpl>(25);
            if (this.object != null) {
                Validate.isTrue((boolean)context.getObjectClass().isInstance(this.object), (String)"setAll() object class '%s' is not compatible with POJO class '%s'", (Object[])new Object[]{this.object.getClass().getName(), context.getObjectClass().getName()});
                context = context.getClassInfo().newContext(this.object);
            }
            for (Map.Entry<String, Triple<Object, CQLDataType, TypeCodec<?>>> e : context.getNonPrimaryKeyColumnValues(table.getName()).entrySet()) {
                assignments.add(new SetAssignmentImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return assignments;
        }

        @Override
        boolean containsBindMarker() {
            return false;
        }

        @Override
        boolean isIdempotent() {
            return true;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            throw new IllegalStateException("should not be called");
        }
    }

    static class DelayedReplaceAssignmentImpl
    extends DelayedSetAssignmentImpl
    implements WithOldValue {
        protected volatile Object old;

        DelayedReplaceAssignmentImpl(CharSequence name, Object old) {
            super(name);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        DelayedReplaceAssignmentImpl(Object object, CharSequence name, Object old) {
            super(object, name);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        @Override
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> table, ClassInfoImpl.POJOContext context) {
            Triple<Object, CQLDataType, TypeCodec<?>> neval;
            if (this.object != null) {
                Validate.isTrue((boolean)context.getObjectClass().isInstance(this.object), (String)"setAll() object class '%s' is not compatible with POJO class '%s'", (Object[])new Object[]{this.object.getClass().getName(), context.getObjectClass().getName()});
                context = context.getClassInfo().newContext(this.object);
            }
            if (table.getColumnImpl(this.name) == null) {
                return Collections.emptyList();
            }
            try {
                neval = context.getColumnValue(table.getName(), this.name);
            }
            catch (EmptyOptionalPrimaryKeyException e) {
                neval = null;
            }
            return Arrays.asList(new ReplaceAssignmentImpl(this.name, neval, this.old));
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.old);
        }

        @Override
        boolean isIdempotent() {
            return Utils.isIdempotent(this.old);
        }

        @Override
        public Object getOldValue() {
            return this.old;
        }
    }

    static class DelayedSetAssignmentImpl
    extends SetAssignmentImpl
    implements DelayedWithObject {
        final Object object;

        DelayedSetAssignmentImpl(CharSequence name) {
            this((Object)null, name);
        }

        DelayedSetAssignmentImpl(Object object, CharSequence name) {
            super(name);
            this.object = object;
        }

        @Override
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> table, ClassInfoImpl.POJOContext context) {
            if (this.object != null) {
                Validate.isTrue((boolean)context.getObjectClass().isInstance(this.object), (String)"setAll() object class '%s' is not compatible with POJO class '%s'", (Object[])new Object[]{this.object.getClass().getName(), context.getObjectClass().getName()});
                context = context.getClassInfo().newContext(this.object);
            }
            if (table.getColumnImpl(this.name) == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(new SetAssignmentImpl(this.name, context.getColumnValue(table.getName(), this.name)));
        }

        @Override
        boolean containsBindMarker() {
            return false;
        }

        @Override
        boolean isIdempotent() {
            return true;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            throw new IllegalStateException("should not be called");
        }
    }

    static class PreviousAssignmentImpl
    extends AssignmentImpl
    implements WithOldValue {
        protected volatile Object old;

        PreviousAssignmentImpl(CharSequence name, Object old) {
            super(name);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        }

        @Override
        boolean containsBindMarker() {
            return false;
        }

        @Override
        boolean isIdempotent() {
            return true;
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateColumnAndValue(this.name, this.old, true);
        }

        @Override
        public Object getOldValue() {
            return this.old;
        }
    }

    static class ReplaceAssignmentImpl
    extends SetAssignmentImpl
    implements WithOldValue {
        protected volatile Object old;

        ReplaceAssignmentImpl(CharSequence name, Object value, Object old) {
            super(name, value);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        ReplaceAssignmentImpl(CharSequence name, Triple<Object, CQLDataType, TypeCodec<?>> tvalue, Object old) {
            super(name, tvalue);
            if (old instanceof Optional) {
                old = ((Optional)old).orElse(null);
            }
            this.old = old;
        }

        @Override
        boolean containsBindMarker() {
            return super.containsBindMarker() || Utils.containsBindMarker(this.old);
        }

        @Override
        boolean isIdempotent() {
            return super.isIdempotent() || Utils.isIdempotent(this.old);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            super.validate(table);
            table.validateColumnAndValue(this.name, this.old, true);
        }

        @Override
        public Object getOldValue() {
            return this.old;
        }
    }

    static class SetAssignmentImpl
    extends AssignmentImpl {
        protected volatile Object value;
        private final CQLDataType definition;
        private final TypeCodec<?> codec;

        SetAssignmentImpl(CharSequence name) {
            this(name, null, null);
        }

        SetAssignmentImpl(CharSequence name, Object value) {
            this(name, value, null);
        }

        SetAssignmentImpl(CharSequence name, Triple<Object, CQLDataType, TypeCodec<?>> tvalue) {
            super(name);
            if (tvalue != null) {
                Object value = tvalue.getLeft();
                if (value instanceof Optional) {
                    value = ((Optional)value).orElse(null);
                }
                this.value = value;
                this.definition = (CQLDataType)tvalue.getMiddle();
                this.codec = (TypeCodec)tvalue.getRight();
            } else {
                this.value = null;
                this.definition = null;
                this.codec = null;
            }
        }

        SetAssignmentImpl(CharSequence name, Object value, CQLDataType definition) {
            super(name);
            if (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            this.value = value;
            this.definition = definition;
            this.codec = null;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            Utils.appendName(tinfo, null, codecRegistry, sb, this.name);
            sb.append("=");
            FieldInfoImpl<?> field = tinfo.getColumnImpl(this.name);
            Utils.appendValue((CQLDataType)(this.definition != null ? this.definition : field.getDataType()), codec != null ? codec : (this.codec != null ? this.codec : field.getCodec(keyspace)), codecRegistry, sb, this.value, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return Utils.isIdempotent(this.value);
        }

        @Override
        void validate(TableInfoImpl<?> table) {
            table.validateColumnAndValue(this.name, this.value);
        }

        Object getValue() {
            return this.value;
        }
    }

    static interface WithOldValue {
        public Object getOldValue();
    }

    static interface DelayedWithObject {
        public <T> List<AssignmentImpl> processWith(TableInfoImpl<?> var1, ClassInfoImpl.POJOContext var2);
    }
}

