/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.driver.Clause;
import org.helenus.driver.codecs.ArgumentsCodec;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.CQLDataType;

public abstract class ClauseImpl
extends Utils.Appendeable
implements Clause {
    protected final CharSequence name;

    ClauseImpl(CharSequence name) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        this.name = name;
    }

    CharSequence getColumnName() {
        return this.name;
    }

    boolean containsColumn(String name) {
        return this.name.toString().equals(name);
    }

    Object firstValue() {
        return null;
    }

    Collection<?> values() {
        return null;
    }

    abstract String getOperation();

    abstract <T> void validate(TableInfoImpl<T> var1);

    static class IsKeyspacedLikeObjectClauseImpl
    extends ClauseImpl
    implements DelayedWithObject {
        IsKeyspacedLikeObjectClauseImpl() {
            super("");
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table, ClassInfoImpl.POJOContext context) {
            Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> pkeys = context.getKeyspaceKeyValues();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(pkeys.size());
            for (Map.Entry<String, Triple<Object, CQLDataType, TypeCodec<?>>> e : pkeys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return clauses;
        }

        @Override
        CharSequence getColumnName() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsColumn(String name) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        String getOperation() {
            return "IS KEYSPACED LIKE OBJECT";
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsBindMarker() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }

        public String toString() {
            return this.getOperation();
        }
    }

    static class IsPartitionedLikeObjectClauseImpl
    extends ClauseImpl
    implements DelayedWithObject {
        IsPartitionedLikeObjectClauseImpl() {
            super("");
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table, ClassInfoImpl.POJOContext context) {
            Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> pkeys = context.getKeyspaceAndPartitionKeyColumnValues(table.getName());
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(pkeys.size());
            for (Map.Entry<String, Triple<Object, CQLDataType, TypeCodec<?>>> e : pkeys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return clauses;
        }

        @Override
        CharSequence getColumnName() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsColumn(String name) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        String getOperation() {
            return "IS PARTITIONED LIKE OBJECT";
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsBindMarker() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }

        public String toString() {
            return this.getOperation();
        }
    }

    static class IsObjectClauseImpl
    extends ClauseImpl
    implements DelayedWithObject {
        IsObjectClauseImpl() {
            super("");
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table, ClassInfoImpl.POJOContext context) {
            Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> pkeys = context.getKeyspaceAndPrimaryKeyColumnValues(table.getName());
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(pkeys.size());
            for (Map.Entry<String, Triple<Object, CQLDataType, TypeCodec<?>>> e : pkeys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return clauses;
        }

        @Override
        CharSequence getColumnName() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsColumn(String name) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        String getOperation() {
            return "IS OBJECT";
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsBindMarker() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }

        public String toString() {
            return this.getOperation();
        }
    }

    static class IsKeyspacedLikeClauseImpl
    extends IsClauseImpl {
        IsKeyspacedLikeClauseImpl(Object object) {
            super(object);
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table) {
            Validate.isTrue((boolean)table.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + table.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Map keys = ((ClassInfoImpl)table.getClassInfo()).getKeyspaceKeys();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (Map.Entry e : keys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue().getValue(this.object)));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS KEYSPACED LIKE";
        }
    }

    static class IsPartitionedLikeClauseImpl
    extends IsClauseImpl {
        IsPartitionedLikeClauseImpl(Object object) {
            super(object);
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table) {
            Validate.isTrue((boolean)table.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + table.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Collection<FieldInfoImpl<T>> keys = table.getKeyspaceAndPartitionKeys();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (FieldInfoImpl<Object> fieldInfoImpl : keys) {
                String name = fieldInfoImpl.isColumn() ? fieldInfoImpl.getColumnName() : fieldInfoImpl.getKeyspaceKeyName();
                clauses.add(new EqClauseImpl((CharSequence)name, fieldInfoImpl.getValue(this.object)));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS PARTITIONED LIKE";
        }
    }

    static class IsClauseImpl
    extends ClauseImpl
    implements Delayed {
        protected final Object object;

        IsClauseImpl(Object object) {
            super("");
            Validate.notNull((Object)object, (String)"invalid null object", (Object[])new Object[0]);
            this.object = object;
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table) {
            Validate.isTrue((boolean)table.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + table.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Collection<FieldInfoImpl<T>> keys = table.getKeyspaceAndPrimaryKeys();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (FieldInfoImpl<Object> fieldInfoImpl : keys) {
                String name = fieldInfoImpl.isColumn() ? fieldInfoImpl.getColumnName() : fieldInfoImpl.getKeyspaceKeyName();
                clauses.add(new EqClauseImpl((CharSequence)name, fieldInfoImpl.getValue(this.object)));
            }
            return clauses;
        }

        @Override
        public <T> List<ClauseImpl> processWith(ClassInfoImpl<T> cinfo) {
            Validate.isTrue((boolean)cinfo.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + cinfo.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Collection<FieldInfoImpl<T>> keys = cinfo.getKeyspaceKeys().values();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (FieldInfoImpl<Object> fieldInfoImpl : keys) {
                clauses.add(new EqClauseImpl((CharSequence)fieldInfoImpl.getKeyspaceKeyName(), fieldInfoImpl.getValue(this.object)));
            }
            return clauses;
        }

        @Override
        CharSequence getColumnName() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsColumn(String name) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        String getOperation() {
            return "IS";
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsBindMarker() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }

        public String toString() {
            return this.name + " " + this.getOperation() + " " + this.object;
        }
    }

    static class CompoundInClauseImpl
    extends ClauseImpl
    implements Clause.Compound,
    Clause.In,
    Compound {
        protected final List<String> names;
        private final List<? extends Collection<?>> values;

        CompoundInClauseImpl(List<String> names, List<? extends Collection<?>> values) {
            super("");
            if (names.size() != values.size()) {
                throw new IllegalArgumentException("mismatched number of column names and collection of values: " + names.size() + " names and " + values.size() + " values");
            }
            this.names = names;
            this.values = values;
        }

        @Override
        public <T> List<ClauseImpl> extractSpecialColumns(TableInfoImpl<T> table) {
            if (table.hasCaseInsensitiveKeys() || table.hasMultiKeys()) {
                ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(this.names.size());
                ArrayList cvalues = new ArrayList(this.names.size());
                ArrayList<String> cnames = new ArrayList<String>(this.names.size());
                for (int i = 0; i < this.names.size(); ++i) {
                    Collection<?> value = this.values.get(i);
                    String name = this.names.get(i);
                    FieldInfoImpl<T> finfo = table.getColumnImpl(name);
                    if (finfo != null && (finfo.isCaseInsensitiveKey() || finfo.isMultiKey())) {
                        clauses.add(new InClauseImpl(name, value));
                        continue;
                    }
                    cnames.add(name);
                    cvalues.add(value);
                }
                if (!clauses.isEmpty()) {
                    if (cnames.size() == 1) {
                        clauses.add(new InClauseImpl((CharSequence)cnames.get(0), (Collection)cvalues.get(0)));
                    } else {
                        clauses.add(new CompoundInClauseImpl(cnames, cvalues));
                    }
                    return clauses;
                }
            }
            return null;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            StringBuilder vsb = new StringBuilder(300);
            int j = 0;
            sb.append('(');
            vsb.append('(');
            for (int i = 0; i < this.names.size(); ++i) {
                Object fv;
                Collection<?> values = this.values.get(i);
                String sname = this.names.get(i);
                if (values.isEmpty()) continue;
                if (j++ > 0) {
                    sb.append(',');
                    vsb.append(',');
                }
                if (values.size() == 1 && Utils.isBindMarker(fv = this.firstValue())) {
                    Utils.appendName(sb, sname);
                    vsb.append(fv);
                    continue;
                }
                Utils.appendName(sb, sname);
                vsb.append('(');
                FieldInfoImpl<?> finfo = tinfo.getColumnImpl(sname);
                if (finfo == null) {
                    if (sname.startsWith("mk_")) {
                        finfo = tinfo.getColumnImpl(sname = sname.substring("mk_".length()));
                        if (finfo != null && finfo.isMultiKey()) {
                            Utils.joinAndAppendValues(codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0), codecRegistry, vsb, ",", values, finfo.getDataType().getElementType(), variables).append(")");
                            continue;
                        }
                    } else if (sname.startsWith("ci_") && (finfo = tinfo.getColumnImpl(sname = sname.substring("ci_".length()))) != null && finfo.isCaseInsensitiveKey()) {
                        Utils.joinAndAppendValues(codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, vsb, ",", values, finfo.getDataType(), variables).append(")");
                        continue;
                    }
                    throw new IllegalStateException("unknown column '" + sname + "'");
                }
                Utils.joinAndAppendValues(codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, vsb, ",", values, finfo.getDataType(), variables).append(")");
            }
            sb.append(") IN ").append((CharSequence)vsb).append(')');
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.values);
        }

        @Override
        CharSequence getColumnName() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsColumn(String name) {
            return this.names.contains(name);
        }

        @Override
        public List<String> getColumnNames() {
            return this.names;
        }

        @Override
        public List<?> getColumnValues() {
            return this.values;
        }

        @Override
        Object firstValue() {
            return this.values.iterator().next();
        }

        @Override
        Collection<?> values() {
            return this.values;
        }

        @Override
        String getOperation() {
            return "IN";
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            for (int i = 0; i < this.names.size(); ++i) {
                table.validateColumnAndValues(this.names.get(i), this.values.get(i));
            }
        }

        public String toString() {
            return this.name + " " + this.getOperation() + " " + this.values;
        }
    }

    static class CompoundEqClauseImpl
    extends CompoundClauseImpl
    implements Clause.Equality {
        CompoundEqClauseImpl(List<String> names, List<?> values) {
            super(names, "=", values);
        }

        CompoundEqClauseImpl(List<String> names, List<?> values, List<CQLDataType> definitions) {
            super(names, "=", values, definitions);
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            for (int i = 0; i < this.names.size(); ++i) {
                table.validateKeyspaceKeyOrColumnAndValue((CharSequence)this.names.get(i), this.values.get(i));
            }
        }
    }

    static class CompoundClauseImpl
    extends ClauseImpl
    implements Clause.Compound,
    Compound {
        private final String op;
        protected final List<String> names;
        protected final List<?> values;
        protected final List<CQLDataType> definitions;

        CompoundClauseImpl(List<String> names, String op, List<?> values) {
            this(names, op, values, null);
        }

        CompoundClauseImpl(List<String> names, String op, List<?> values, List<CQLDataType> definitions) {
            super("");
            Validate.notNull((Object)op, (String)"invalid null operation", (Object[])new Object[0]);
            if (names.size() != values.size()) {
                throw new IllegalArgumentException("mismatched number of column names and values: " + names.size() + " names and " + values.size() + " values");
            }
            if (definitions != null && names.size() != definitions.size()) {
                throw new IllegalArgumentException("mismatched number of column names and definitions: " + names.size() + " names and " + definitions.size() + " definitions");
            }
            this.names = names;
            this.op = op;
            this.values = values;
            if (definitions != null) {
                this.definitions = definitions;
            } else {
                this.definitions = new ArrayList<CQLDataType>(names.size());
                for (int i = 0; i < names.size(); ++i) {
                    this.definitions.add(null);
                }
            }
        }

        @Override
        public <T> List<ClauseImpl> extractSpecialColumns(TableInfoImpl<T> table) {
            if (table.hasCaseInsensitiveKeys() || table.hasMultiKeys()) {
                ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(this.names.size());
                ArrayList<CQLDataType> cdefinitions = new ArrayList<CQLDataType>(this.names.size());
                ArrayList cvalues = new ArrayList(this.names.size());
                ArrayList<String> cnames = new ArrayList<String>(this.names.size());
                for (int i = 0; i < this.names.size(); ++i) {
                    CQLDataType definition = this.definitions.get(i);
                    Object value = this.values.get(i);
                    String name = this.names.get(i);
                    FieldInfoImpl<T> finfo = table.getColumnImpl(name);
                    if (finfo != null && (finfo.isCaseInsensitiveKey() || finfo.isMultiKey())) {
                        clauses.add(new SimpleClauseImpl(name, this.op, value, definition));
                        continue;
                    }
                    cnames.add(name);
                    cvalues.add(value);
                    cdefinitions.add(definition);
                }
                if (!clauses.isEmpty()) {
                    if (cnames.size() == 1) {
                        clauses.add(new SimpleClauseImpl((CharSequence)cnames.get(0), this.op, cvalues.get(0), (CQLDataType)cdefinitions.get(0)));
                    } else {
                        clauses.add(new CompoundClauseImpl(cnames, this.op, cvalues, cdefinitions));
                    }
                    return clauses;
                }
            }
            return null;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            StringBuilder vsb = new StringBuilder(300);
            sb.append('(');
            vsb.append('(');
            for (int i = 0; i < this.names.size(); ++i) {
                CQLDataType definition = this.definitions.get(i);
                Object value = this.values.get(i);
                String sname = this.names.get(i);
                if (i > 0) {
                    sb.append(',');
                    vsb.append(',');
                }
                Utils.appendName(sb, sname);
                FieldInfoImpl<?> finfo = tinfo.getColumnImpl(sname);
                if (finfo == null) {
                    if (sname.startsWith("mk_")) {
                        finfo = tinfo.getColumnImpl(sname = sname.substring("mk_".length()));
                        if (finfo != null && finfo.isMultiKey()) {
                            Utils.appendValue(definition != null ? definition : finfo.getDataType().getElementType(), codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0), codecRegistry, vsb, value, variables);
                            continue;
                        }
                    } else if (sname.startsWith("ci_") && (finfo = tinfo.getColumnImpl(sname = sname.substring("ci_".length()))) != null && finfo.isCaseInsensitiveKey()) {
                        Utils.appendValue((CQLDataType)(definition != null ? definition : finfo.getDataType()), codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, vsb, value, variables);
                        continue;
                    }
                    throw new IllegalStateException("unknown column '" + sname + "'");
                }
                Utils.appendValue((CQLDataType)(definition != null ? definition : finfo.getDataType()), codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, vsb, value, variables);
            }
            sb.append(')').append(this.op).append((CharSequence)vsb).append(')');
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.values);
        }

        @Override
        CharSequence getColumnName() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        boolean containsColumn(String name) {
            return this.names.contains(name);
        }

        @Override
        public List<String> getColumnNames() {
            return this.names;
        }

        @Override
        public List<?> getColumnValues() {
            return this.values;
        }

        @Override
        Object firstValue() {
            return !this.values.isEmpty() ? this.values.get(0) : null;
        }

        @Override
        Collection<?> values() {
            return this.values;
        }

        @Override
        String getOperation() {
            return this.op;
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            for (int i = 0; i < this.names.size(); ++i) {
                table.validateColumnAndValue(this.names.get(i), this.values.get(i));
            }
        }

        public String toString() {
            return this.names + " " + this.getOperation() + " " + this.values;
        }
    }

    static class ContainsKeyClauseImpl
    extends ClauseImpl {
        private final Object key;

        ContainsKeyClauseImpl(CharSequence name, Object key) {
            super(name);
            this.key = key;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            Utils.appendName(tinfo, null, codecRegistry, sb, this.name).append(" CONTAINS KEY ");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendValue(finfo.getDataType().getFirstArgumentType(), codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0), codecRegistry, sb, this.key, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.key);
        }

        @Override
        Object firstValue() {
            return this.key;
        }

        @Override
        Collection<?> values() {
            return Collections.singleton(this.key);
        }

        @Override
        String getOperation() {
            return "CONTAINS KEY";
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateMapColumnAndKey(this.name, this.key);
        }

        public String toString() {
            return this.name + " " + this.getOperation() + " " + this.key;
        }
    }

    static class ContainsClauseImpl
    extends ClauseImpl {
        private final Object value;

        ContainsClauseImpl(CharSequence name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            Utils.appendName(tinfo, null, codecRegistry, sb, this.name).append(" CONTAINS ");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            Utils.appendValue(finfo.getDataType().getElementType(), codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0), codecRegistry, sb, this.value, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        Object firstValue() {
            return this.value;
        }

        @Override
        Collection<?> values() {
            return Collections.singleton(this.value);
        }

        @Override
        String getOperation() {
            return "CONTAINS";
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateCollectionColumnAndValue(this.name, this.value);
        }

        public String toString() {
            return this.name + " " + this.getOperation() + " " + this.value;
        }
    }

    static class InClauseImpl
    extends ClauseImpl
    implements Clause.In {
        private final Collection<?> values;

        InClauseImpl(CharSequence name, Collection<?> values) {
            super(name);
            this.values = values;
            Validate.isTrue((!CollectionUtils.isEmpty(values) ? 1 : 0) != 0, (String)"missing values for IN clause", (Object[])new Object[0]);
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            Object fv;
            if (this.values.size() == 1 && Utils.isBindMarker(fv = this.firstValue())) {
                Utils.appendName(tinfo, null, codecRegistry, sb, this.name).append(" IN ").append(fv);
                return;
            }
            Utils.appendName(tinfo, null, codecRegistry, sb, this.name).append(" IN (");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            if (finfo == null) {
                String sname = this.name.toString();
                if (sname.startsWith("mk_")) {
                    finfo = tinfo.getColumnImpl(sname = sname.substring("mk_".length()));
                    if (finfo != null && finfo.isMultiKey()) {
                        Utils.joinAndAppendValues(codec != null ? codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0), codecRegistry, sb, ",", this.values, finfo.getDataType().getElementType(), variables).append(")");
                        return;
                    }
                } else if (sname.startsWith("ci_") && (finfo = tinfo.getColumnImpl(sname = sname.substring("ci_".length()))) != null && finfo.isCaseInsensitiveKey()) {
                    Utils.joinAndAppendValues(codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, sb, ",", this.values, finfo.getDataType(), variables).append(")");
                    return;
                }
                throw new IllegalStateException("unknown column '" + sname + "'");
            }
            Utils.joinAndAppendValues(codec != null ? codec : finfo.getCodec(keyspace), codecRegistry, sb, ",", this.values, finfo.getDataType(), variables).append(")");
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.values);
        }

        @Override
        Object firstValue() {
            return !this.values().isEmpty() ? this.values.iterator().next() : null;
        }

        @Override
        Collection<?> values() {
            return this.values;
        }

        @Override
        String getOperation() {
            return "IN";
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateColumnAndValues(this.name, this.values);
        }

        public String toString() {
            return this.name + " " + this.getOperation() + " " + this.values;
        }
    }

    static class EqClauseImpl
    extends SimpleClauseImpl
    implements Clause.Equality {
        EqClauseImpl(CharSequence name, Object value) {
            super(name, "=", value);
        }

        EqClauseImpl(CharSequence name, Triple<Object, CQLDataType, TypeCodec<?>> tvalue) {
            super(name, "=", tvalue);
        }

        EqClauseImpl(CharSequence name, Object value, CQLDataType definition) {
            super(name, "=", value, definition);
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateKeyspaceKeyOrColumnAndValue(this.name, this.value);
        }
    }

    static class SimpleClauseImpl
    extends ClauseImpl {
        private final String op;
        protected final Object value;
        protected final CQLDataType definition;
        protected final TypeCodec<?> codec;

        SimpleClauseImpl(CharSequence name, String op, Object value) {
            this(name, op, value, null);
        }

        SimpleClauseImpl(CharSequence name, String op, Triple<Object, CQLDataType, TypeCodec<?>> tvalue) {
            super(name);
            Validate.notNull((Object)op, (String)"invalid null operation", (Object[])new Object[0]);
            this.op = op;
            if (tvalue != null) {
                this.value = tvalue.getLeft();
                this.definition = (CQLDataType)tvalue.getMiddle();
                this.codec = (TypeCodec)tvalue.getRight();
            } else {
                this.value = null;
                this.definition = null;
                this.codec = null;
            }
        }

        SimpleClauseImpl(CharSequence name, String op, Object value, CQLDataType definition) {
            super(name);
            Validate.notNull((Object)op, (String)"invalid null operation", (Object[])new Object[0]);
            this.op = op;
            this.value = value;
            this.definition = definition;
            this.codec = null;
        }

        @Override
        void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
            Utils.appendName(tinfo, null, codecRegistry, sb, this.name).append(this.op);
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            if (finfo == null) {
                String sname = this.name.toString();
                if (sname.startsWith("mk_")) {
                    finfo = tinfo.getColumnImpl(sname = sname.substring("mk_".length()));
                    if (finfo != null && finfo.isMultiKey()) {
                        Utils.appendValue(this.definition != null ? this.definition : finfo.getDataType().getElementType(), codec != null ? codec : (this.codec != null ? this.codec : ((ArgumentsCodec)finfo.getCodec(keyspace)).codec(0)), codecRegistry, sb, this.value, variables);
                        return;
                    }
                } else if (sname.startsWith("ci_") && (finfo = tinfo.getColumnImpl(sname = sname.substring("ci_".length()))) != null && finfo.isCaseInsensitiveKey()) {
                    Utils.appendValue((CQLDataType)(this.definition != null ? this.definition : finfo.getDataType()), codec != null ? codec : (this.codec != null ? this.codec : finfo.getCodec(keyspace)), codecRegistry, sb, this.value, variables);
                    return;
                }
                throw new IllegalStateException("unknown column '" + this.name + "'");
            }
            Utils.appendValue((CQLDataType)(this.definition != null ? this.definition : finfo.getDataType()), codec != null ? codec : (this.codec != null ? this.codec : finfo.getCodec(keyspace)), codecRegistry, sb, this.value, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        Object firstValue() {
            return this.value;
        }

        @Override
        Collection<?> values() {
            return Collections.singleton(this.value);
        }

        @Override
        String getOperation() {
            return this.op;
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateColumnAndValue(this.name, this.value);
        }

        public String toString() {
            return this.name + " " + this.getOperation() + " " + this.firstValue();
        }
    }

    static interface Compound {
        public List<String> getColumnNames();

        public List<?> getColumnValues();

        public <T> List<ClauseImpl> extractSpecialColumns(TableInfoImpl<T> var1);
    }

    static interface DelayedWithObject {
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> var1, ClassInfoImpl.POJOContext var2);
    }

    static interface Delayed {
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> var1);

        public <T> List<ClauseImpl> processWith(ClassInfoImpl<T> var1);
    }
}

