/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.helenus.commons.collections.DirectedGraph;
import org.helenus.commons.collections.GraphUtils;
import org.helenus.commons.collections.graph.ConcurrentHashDirectedGraph;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateSchemas;
import org.helenus.driver.ExcludedKeyspaceKeyException;
import org.helenus.driver.GroupableStatement;
import org.helenus.driver.ParentStatement;
import org.helenus.driver.SequenceableStatement;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.CreateSchemaImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.GroupImpl;
import org.helenus.driver.impl.RootClassInfoImpl;
import org.helenus.driver.impl.SequenceImpl;
import org.helenus.driver.impl.SequenceStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTRootClassInfoImpl;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.persistence.Entity;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.RootEntity;
import org.helenus.driver.persistence.TypeEntity;
import org.helenus.driver.persistence.UDTEntity;
import org.helenus.driver.persistence.UDTRootEntity;
import org.helenus.driver.persistence.UDTTypeEntity;
import org.reflections.Reflections;

public class CreateSchemasImpl
extends SequenceStatementImpl<Void, VoidFuture, Void>
implements CreateSchemas {
    private final Object[] pkgs;
    private final boolean matching;
    private final Map<Keyspace, List<ClassInfoImpl<?>>> keyspaces;
    private volatile List<ClassInfoImpl.Context> contexts;
    private volatile boolean ifNotExists;
    private final WhereImpl where;

    public CreateSchemasImpl(String[] pkgs, boolean matching, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, (String)null, mgr, bridge);
        Validate.notNull((Object)pkgs, (String)"invalid null packages", (Object[])new Object[0]);
        this.pkgs = Stream.of(pkgs).filter(p -> p != null).toArray();
        this.matching = matching;
        this.keyspaces = this.findKeyspaces();
        this.where = new WhereImpl(this);
    }

    private Map<Keyspace, List<ClassInfoImpl<?>>> findKeyspaces() {
        List<ClassInfoImpl<?>> cs;
        Keyspace old;
        Keyspace k;
        ClassInfoImpl cinfo;
        DirectedGraph cs2;
        Keyspace old2;
        Keyspace k2;
        UDTClassInfoImpl cinfo2;
        HashMap<String, Keyspace> keyspaces = new HashMap<String, Keyspace>(25);
        Reflections reflections = new Reflections(this.pkgs);
        LinkedHashMap<Keyspace, DirectedGraph> udtcinfos = new LinkedHashMap<Keyspace, DirectedGraph>(25);
        for (Class clazz : reflections.getTypesAnnotatedWith(UDTEntity.class, true)) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            cinfo2 = (UDTClassInfoImpl)this.mgr.getClassInfoImpl(clazz);
            k2 = cinfo2.getKeyspace();
            old2 = keyspaces.put(k2.name(), k2);
            cs2 = (DirectedGraph)udtcinfos.get(k2);
            if (cs2 == null) {
                cs2 = new ConcurrentHashDirectedGraph();
                udtcinfos.put(k2, cs2);
            }
            cs2.add((Object)cinfo2, cinfo2.udts());
            if (old2 == null || k2.equals(old2)) continue;
            throw new IllegalArgumentException("two different @Keyspace annotations found with class '" + clazz.getName() + "': " + old2 + " and: " + k2);
        }
        for (Class clazz : reflections.getTypesAnnotatedWith(UDTRootEntity.class, true)) {
            if (ReflectionUtils.findFirstClassAnnotatedWith((Class)clazz, UDTRootEntity.class) != clazz) continue;
            cinfo2 = (UDTClassInfoImpl)this.mgr.getClassInfoImpl(clazz);
            k2 = cinfo2.getKeyspace();
            old2 = keyspaces.put(k2.name(), k2);
            cs2 = (DirectedGraph)udtcinfos.get(k2);
            if (cs2 == null) {
                cs2 = new ConcurrentHashDirectedGraph();
                udtcinfos.put(k2, cs2);
            }
            cs2.add((Object)cinfo2, cinfo2.udts());
            if (old2 != null && !k2.equals(old2)) {
                throw new IllegalArgumentException("two different @Keyspace annotations found with class '" + clazz.getName() + "': " + old2 + " and: " + k2);
            }
            DirectedGraph fcs = cs2;
            ((UDTRootClassInfoImpl)cinfo2).typeImpls().forEach(tcinfo -> fcs.add(tcinfo, tcinfo.udts()));
        }
        for (Class clazz : reflections.getTypesAnnotatedWith(UDTTypeEntity.class, true)) {
            if (ReflectionUtils.findFirstClassAnnotatedWith((Class)clazz, UDTTypeEntity.class) != clazz) continue;
            cinfo2 = (UDTClassInfoImpl)this.mgr.getClassInfoImpl(clazz);
            k2 = cinfo2.getKeyspace();
            old2 = keyspaces.put(k2.name(), k2);
            cs2 = (DirectedGraph)udtcinfos.get(k2);
            if (cs2 == null) {
                cs2 = new ConcurrentHashDirectedGraph();
                udtcinfos.put(k2, cs2);
            }
            cs2.add((Object)cinfo2, cinfo2.udts());
            if (old2 != null && !k2.equals(old2)) {
                throw new IllegalArgumentException("two different @Keyspace annotations found with class '" + clazz.getName() + "': " + old2 + " and: " + k2);
            }
            if (cs2.contains((Object)cinfo2)) continue;
            cs2.add((Object)cinfo2, cinfo2.udts());
        }
        Map<Keyspace, List<ClassInfoImpl<?>>> cinfos = udtcinfos.entrySet().stream().collect(Collectors.toMap(e -> (Keyspace)e.getKey(), e -> {
            List l = GraphUtils.sort((DirectedGraph)((DirectedGraph)e.getValue()), o -> o.getObjectClass(), o -> o.getObjectClass().getSimpleName());
            Collections.reverse(l);
            return l;
        }));
        for (Class clazz : reflections.getTypesAnnotatedWith(Entity.class, true)) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            cinfo = this.mgr.getClassInfoImpl(clazz);
            k = cinfo.getKeyspace();
            old = keyspaces.put(k.name(), k);
            cs = cinfos.get(k);
            if (cs == null) {
                cs = new ArrayList(25);
                cinfos.put(k, cs);
            }
            cs.add(cinfo);
            if (old == null || k.equals(old)) continue;
            throw new IllegalArgumentException("two different @Keyspace annotations found with class '" + clazz.getName() + "': " + old + " and: " + k);
        }
        for (Class clazz : reflections.getTypesAnnotatedWith(RootEntity.class, true)) {
            if (ReflectionUtils.findFirstClassAnnotatedWith((Class)clazz, RootEntity.class) != clazz) continue;
            cinfo = this.mgr.getClassInfoImpl(clazz);
            k = cinfo.getKeyspace();
            old = keyspaces.put(k.name(), k);
            cs = cinfos.get(k);
            if (cs == null) {
                cs = new ArrayList(32);
                cinfos.put(k, cs);
            }
            cs.add(cinfo);
            if (old != null && !k.equals(old)) {
                throw new IllegalArgumentException("two different @Keyspace annotations found with class '" + clazz.getName() + "': " + old + " and: " + k);
            }
            List<ClassInfoImpl<?>> fcs = cs;
            ((RootClassInfoImpl)cinfo).typeImpls().forEach(tcinfo -> fcs.add((ClassInfoImpl<?>)tcinfo));
        }
        for (Class clazz : reflections.getTypesAnnotatedWith(TypeEntity.class, true)) {
            if (ReflectionUtils.findFirstClassAnnotatedWith((Class)clazz, TypeEntity.class) != clazz) continue;
            cinfo = this.mgr.getClassInfoImpl(clazz);
            k = cinfo.getKeyspace();
            old = keyspaces.put(k.name(), k);
            cs = cinfos.get(k);
            if (cs == null) {
                cs = new ArrayList(32);
                cinfos.put(k, cs);
            }
            cs.add(cinfo);
            if (old != null && !k.equals(old)) {
                throw new IllegalArgumentException("two different @Keyspace annotations found with class '" + clazz.getName() + "': " + old + " and: " + k);
            }
            if (cs.contains(cinfo)) continue;
            cs.add(cinfo);
        }
        return cinfos;
    }

    private List<ClassInfoImpl.Context> getContexts() {
        if (this.contexts == null) {
            ArrayList<ClassInfoImpl.Context> ucontexts = new ArrayList<ClassInfoImpl.Context>(32);
            ArrayList<ClassInfoImpl.Context> contexts = new ArrayList<ClassInfoImpl.Context>(32);
            block3: for (List<ClassInfoImpl<?>> cinfos : this.keyspaces.values()) {
                block4: for (ClassInfoImpl<?> cinfo : cinfos) {
                    ClassInfoImpl.Context context = cinfo.newContext();
                    IllegalArgumentException iae = null;
                    int found = 0;
                    for (Map.Entry<String, FieldInfoImpl<?>> e : cinfo.getKeyspaceKeyTypes().entrySet()) {
                        String type = e.getKey();
                        FieldInfoImpl<?> finfo = e.getValue();
                        if (!this.where.keyspaceKeys.containsKey(type)) continue block3;
                        ++found;
                        try {
                            context.addKeyspaceKey(finfo.getKeyspaceKey().name(), this.where.keyspaceKeys.get(type));
                        }
                        catch (ExcludedKeyspaceKeyException ee) {
                            continue block4;
                        }
                        catch (IllegalArgumentException ee) {
                            if (iae != null) continue;
                            iae = ee;
                        }
                    }
                    if (found != this.where.keyspaceKeys.size() && this.matching) continue;
                    if (iae != null) {
                        throw iae;
                    }
                    if (cinfo instanceof UDTClassInfoImpl) {
                        ucontexts.add(context);
                        continue;
                    }
                    contexts.add(context);
                }
            }
            this.contexts = new ArrayList<ClassInfoImpl.Context>(ucontexts.size() + contexts.size());
            this.contexts.addAll(ucontexts);
            this.contexts.addAll(contexts);
        }
        return this.contexts;
    }

    @Override
    protected void setDirty() {
        super.setDirty();
        this.contexts = null;
    }

    @Override
    protected final List<StatementImpl<?, ?, ?>> buildSequencedStatements() {
        List<ClassInfoImpl.Context> contexts = this.getContexts();
        HashSet keyspaces = new HashSet(contexts.size() * 3);
        HashMap tables = new HashMap(contexts.size() * 3);
        GroupImpl kgroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        GroupImpl tgroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        GroupImpl igroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        SequenceImpl yseq = this.init(new SequenceImpl(Optional.empty(), new SequenceableStatement[0], this.mgr, this.bridge));
        GroupImpl group = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        contexts.forEach(c -> {
            CreateSchemaImpl cs = this.init(new CreateSchemaImpl((ClassInfoImpl.Context)c, this.mgr, this.bridge));
            if (this.ifNotExists) {
                cs.ifNotExists();
            }
            cs.buildSequencedStatements(keyspaces, tables, kgroup, tgroup, igroup, yseq, group);
        });
        return Stream.of(kgroup, yseq, tgroup, igroup, group).filter(g -> !((ParentStatement)g).isEmpty()).collect(Collectors.toList());
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" CREATE");
    }

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("SCHEMAS");
    }

    public Set<Class<?>> getObjectClasses() {
        return ((Stream)this.objectClasses().sequential()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<ClassInfo<?>> getClassInfos() {
        return ((Stream)this.classInfos().sequential()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<ClassInfo<?>> getDefinedClassInfos() {
        return ((Stream)this.definedClassInfos().sequential()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Stream<Class<?>> objectClasses() {
        return this.getContexts().stream().flatMap(c -> c.getClassInfo().objectClasses()).distinct();
    }

    public Stream<ClassInfo<?>> classInfos() {
        return this.getContexts().stream().flatMap(c -> c.getClassInfo().classInfos()).distinct();
    }

    public Stream<ClassInfo<?>> definedClassInfos() {
        return this.keyspaces.values().stream().flatMap(cl -> cl.stream()).flatMap(cl -> cl.classInfos()).distinct();
    }

    public CreateSchemas ifNotExists() {
        this.ifNotExists = true;
        this.setDirty();
        return this;
    }

    public CreateSchemas.Where where(Clause clause) {
        return this.where.and(clause);
    }

    public CreateSchemas.Where where() {
        return this.where;
    }

    public static class WhereImpl
    extends ForwardingStatementImpl<Void, VoidFuture, Void, CreateSchemasImpl>
    implements CreateSchemas.Where {
        private final Map<String, Object> keyspaceKeys = new HashMap<String, Object>(8);

        WhereImpl(CreateSchemasImpl statement) {
            super(statement);
        }

        public CreateSchemas.Where and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a CREATE SCHEMAS statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((CreateSchemasImpl)this.statement).getContext().getClassInfo())) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                if (c instanceof ClauseImpl.CompoundEqClauseImpl) {
                    ClauseImpl.Compound compound = (ClauseImpl.Compound)((Object)c);
                    List<String> names = compound.getColumnNames();
                    List<?> values = compound.getColumnValues();
                    for (int i = 0; i < names.size(); ++i) {
                        this.keyspaceKeys.put(names.get(i), values.get(i));
                    }
                } else {
                    this.keyspaceKeys.put(c.getColumnName().toString(), c.firstValue());
                }
                this.setDirty();
            }
            return this;
        }
    }
}

