/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.TypeCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.commons.collections.iterators.CombinationIterator;
import org.helenus.driver.Clause;
import org.helenus.driver.Delete;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.Using;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.codecs.ArgumentsCodec;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.EmptyOptionalPrimaryKeyException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.InsertImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UsingImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Table;

public class DeleteImpl<T>
extends StatementImpl<Void, VoidFuture, T>
implements Delete<T> {
    private final List<TableInfoImpl<T>> tables = new ArrayList<TableInfoImpl<T>>(8);
    protected List<Object> columnNames;
    private final WhereImpl<T> where;
    private final OptionsImpl<T> usings;
    private final ConditionsImpl<T> conditions;
    private boolean ifExists = false;
    protected boolean allSelected = false;
    private final Map<String, Object> pkeys_override;

    public DeleteImpl(ClassInfoImpl.Context context, String[] tables, List<Object> columnNames, boolean allSelected, StatementManagerImpl mgr, StatementBridge bridge) {
        this(context, tables, columnNames, allSelected, null, mgr, bridge);
    }

    DeleteImpl(ClassInfoImpl.Context context, String[] tables, List<Object> columnNames, boolean allSelected, Map<String, Object> pkeys_override, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        if (tables != null) {
            for (String table : tables) {
                if (table == null) continue;
                this.tables.add((TableInfoImpl)context.getClassInfo().getTable(table));
            }
        } else {
            this.tables.addAll(context.getClassInfo().getTablesImpl());
        }
        this.columnNames = columnNames;
        this.allSelected = allSelected;
        Validate.isTrue((allSelected || !CollectionUtils.isEmpty(columnNames) ? 1 : 0) != 0, (String)"must select at least one column", (Object[])new Object[0]);
        this.where = new WhereImpl(this);
        this.usings = new OptionsImpl(this);
        this.conditions = new ConditionsImpl(this);
        this.pkeys_override = pkeys_override;
    }

    DeleteImpl(ClassInfoImpl.Context context, TableInfoImpl<T> table, List<UsingImpl<?>> usings, boolean ifExists, List<ClauseImpl> conditions, Map<String, Object> pkeys_override, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        this.tables.add(table);
        this.columnNames = null;
        this.allSelected = true;
        this.where = new WhereImpl(this);
        this.usings = new OptionsImpl(this, usings);
        this.ifExists = ifExists;
        this.conditions = new ConditionsImpl(this, conditions);
        this.pkeys_override = pkeys_override;
    }

    private void andClause(TableInfoImpl<T> table, List<ClauseImpl> clauses, ClauseImpl clause) {
        if (clause instanceof ClauseImpl.Delayed) {
            ((ClauseImpl.Delayed)((Object)clause)).processWith(table).forEach(c -> this.andClause(table, clauses, (ClauseImpl)c));
        } else if (clause instanceof ClauseImpl.DelayedWithObject) {
            ClassInfoImpl.POJOContext pctx = this.getPOJOContext();
            Validate.isTrue((pctx != null ? 1 : 0) != 0, (String)"unsupported clause '%s' for a DELETE statement", (Object[])new Object[]{clause.getOperation()});
            ((ClauseImpl.DelayedWithObject)((Object)clause)).processWith(table, pctx).forEach(c -> this.andClause(table, clauses, (ClauseImpl)c));
        } else {
            List<ClauseImpl> eclauses;
            if (clause instanceof ClauseImpl.Compound && (eclauses = ((ClauseImpl.Compound)((Object)clause)).extractSpecialColumns(table)) != null) {
                eclauses.forEach(c -> this.andClause(table, clauses, (ClauseImpl)c));
                return;
            }
            CharSequence name = clause.getColumnName();
            if (table.hasPrimaryKey(name)) {
                clause.validate(table);
                if (clause instanceof ClauseImpl.InClauseImpl) {
                    Validate.isTrue((table.isLastPartitionKey(name) || table.isMultiKey(name) ? 1 : 0) != 0, (String)"'IN' clause is only supported for the last column of the partition key or for a multi-key in a DELETE statement: %s", (Object[])new Object[]{name});
                } else if (clause instanceof ClauseImpl.CompoundInClauseImpl) {
                    for (String cname : ((ClauseImpl.CompoundInClauseImpl)clause).getColumnNames()) {
                        Validate.isTrue((table.isLastPartitionKey(cname) || table.isMultiKey(cname) ? 1 : 0) != 0, (String)"'IN' clause is only supported for the last column of the partition key or for a multi-key in a DELETE statement: %s", (Object[])new Object[]{cname});
                    }
                }
                clauses.add(clause);
            }
        }
    }

    void buildQueryString(TableInfoImpl<T> table, List<StringBuilder> builders) {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE ");
        if (this.columnNames != null) {
            ArrayList<Object> cns = new ArrayList<Object>(this.columnNames.size());
            for (Object name : this.columnNames) {
                if (!table.hasColumn(name)) continue;
                table.validateNotMandatoryOrPrimaryKeyColumn(name);
                cns.add(name);
            }
            if (cns.isEmpty()) {
                return;
            }
            Utils.joinAndAppendNames(table, null, this.mgr.getCodecRegistry(), builder, ",", cns);
            builder.append(" ");
        }
        builder.append("FROM ");
        if (this.getKeyspace() != null) {
            Utils.appendName(builder, this.getKeyspace()).append(".");
        }
        Utils.appendName(builder, table.getName());
        if (!((OptionsImpl)this.usings).usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(this.getKeyspace(), table, null, this.mgr.getCodecRegistry(), builder, " AND ", ((OptionsImpl)this.usings).usings, null);
        }
        Collection<FieldInfoImpl<T>> multiKeys = table.getMultiKeys();
        Collection<FieldInfoImpl<T>> caseInsensitiveKeys = table.getCaseInsensitiveKeys();
        if (!((WhereImpl)this.where).clauses.isEmpty()) {
            List whereClauses = ((WhereImpl)this.where).getClauses(table);
            ArrayList<ClauseImpl> cs = new ArrayList<ClauseImpl>(whereClauses.size());
            for (ClauseImpl c : whereClauses) {
                this.andClause(table, cs, c);
            }
            if (cs.isEmpty()) {
                return;
            }
            builder.append(" WHERE ");
            if (!caseInsensitiveKeys.isEmpty() || !multiKeys.isEmpty()) {
                ArrayList sets = new ArrayList(multiKeys.size());
                ListIterator<ClauseImpl> i = cs.listIterator();
                while (i.hasNext()) {
                    FieldInfoImpl<T> finfo;
                    String name;
                    ClauseImpl clauseImpl = (ClauseImpl)i.next();
                    if (clauseImpl instanceof ClauseImpl.SimpleClauseImpl) {
                        name = clauseImpl.getColumnName().toString();
                        finfo = table.getColumnImpl(name);
                        if (finfo == null) continue;
                        boolean ci = finfo.isCaseInsensitiveKey();
                        if (finfo.isMultiKey()) {
                            i.remove();
                            ArrayList<ClauseImpl.EqClauseImpl> set = new ArrayList<ClauseImpl.EqClauseImpl>();
                            String mkname = "mk_" + name;
                            for (Object v2 : clauseImpl.values()) {
                                if (v2 instanceof Collection) {
                                    for (Object sv : (Collection)v2) {
                                        if (ci && sv != null) {
                                            set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, StringUtils.lowerCase((String)sv.toString())));
                                            continue;
                                        }
                                        set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, sv));
                                    }
                                    continue;
                                }
                                if (ci && v2 != null) {
                                    set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, StringUtils.lowerCase((String)v2.toString())));
                                    continue;
                                }
                                set.add(new ClauseImpl.EqClauseImpl((CharSequence)mkname, v2));
                            }
                            if (set.isEmpty()) continue;
                            sets.add(set);
                            continue;
                        }
                        if (!ci) continue;
                        Object v3 = clauseImpl.firstValue();
                        i.set(new ClauseImpl.SimpleClauseImpl((CharSequence)("ci_" + name), clauseImpl.getOperation(), v3 != null ? StringUtils.lowerCase((String)v3.toString()) : null));
                        continue;
                    }
                    if (!(clauseImpl instanceof ClauseImpl.InClauseImpl) || (finfo = table.getColumnImpl(name = clauseImpl.getColumnName().toString())) == null || !finfo.isCaseInsensitiveKey()) continue;
                    i.set(new ClauseImpl.InClauseImpl("ci_" + name, clauseImpl.values().stream().map(v -> v != null ? StringUtils.lowerCase((String)v.toString()) : null).collect(Collectors.toCollection(LinkedHashSet::new))));
                }
                if (!sets.isEmpty()) {
                    Collection[] asets = new Collection[sets.size()];
                    CombinationIterator combinationIterator = new CombinationIterator(ClauseImpl.EqClauseImpl.class, sets.toArray(asets));
                    while (combinationIterator.hasNext()) {
                        StringBuilder sb = new StringBuilder(builder);
                        Utils.joinAndAppend(this.getKeyspace(), table, null, this.mgr.getCodecRegistry(), sb, " AND ", (Collection)combinationIterator.next(), cs, null);
                        builders.add(this.finishBuildingQueryString(table, sb));
                    }
                    return;
                }
            }
            Utils.joinAndAppend(this.getKeyspace(), table, null, this.mgr.getCodecRegistry(), builder, " AND ", cs, null);
        } else {
            try {
                Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> pkeys;
                try {
                    pkeys = this.pkeys_override == null ? this.getPOJOContext().getPrimaryKeyColumnValues(table.getName()) : this.getPOJOContext().getPrimaryKeyColumnValues(table.getName(), this.pkeys_override);
                }
                catch (EmptyOptionalPrimaryKeyException e) {
                    return;
                }
                if (!pkeys.isEmpty()) {
                    builder.append(" WHERE ");
                    if (!caseInsensitiveKeys.isEmpty()) {
                        for (FieldInfoImpl<T> finfo : caseInsensitiveKeys) {
                            Object name;
                            Triple<Object, CQLDataType, TypeCodec<?>> triple;
                            if (finfo.isMultiKey() || (triple = pkeys.remove(name = finfo.getColumnName())) == null) continue;
                            Object v4 = triple.getLeft();
                            pkeys.put("ci_" + (String)name, Triple.of((Object)(v4 != null ? StringUtils.lowerCase((String)v4.toString()) : null), (Object)triple.getMiddle(), (Object)triple.getRight()));
                        }
                    }
                    if (!multiKeys.isEmpty()) {
                        ArrayList<FieldInfoImpl> cfinfos = new ArrayList<FieldInfoImpl>(multiKeys.size());
                        ArrayList<Object> sets = new ArrayList<Object>(multiKeys.size());
                        for (FieldInfoImpl fieldInfoImpl : multiKeys) {
                            Object set;
                            Triple<Object, CQLDataType, TypeCodec<?>> pset = pkeys.remove(fieldInfoImpl.getColumnName());
                            if (pset == null || (set = (Collection)pset.getLeft()) == null) continue;
                            cfinfos.add(fieldInfoImpl);
                            if (fieldInfoImpl.isCaseInsensitiveKey()) {
                                sets.add(set.stream().map(v -> v != null ? StringUtils.lowerCase((String)v.toString()) : null).collect(Collectors.toCollection(LinkedHashSet::new)));
                                continue;
                            }
                            sets.add(set);
                        }
                        if (!sets.isEmpty()) {
                            Collection[] asets = new Collection[sets.size()];
                            CombinationIterator combinationIterator = new CombinationIterator(Object.class, sets.toArray(asets));
                            while (combinationIterator.hasNext()) {
                                int j = -1;
                                for (Object k : (List)combinationIterator.next()) {
                                    FieldInfoImpl finfo = (FieldInfoImpl)cfinfos.get(++j);
                                    pkeys.put("mk_" + finfo.getColumnName(), Triple.of(k, (Object)finfo.getDataType().getElementType(), (Object)((ArgumentsCodec)finfo.getCodec(this.getKeyspace())).codec(0)));
                                }
                                StringBuilder sb = new StringBuilder(builder);
                                Utils.joinAndAppendNamesAndValues(null, this.mgr.getCodecRegistry(), sb, " AND ", "=", pkeys, null);
                                builders.add(this.finishBuildingQueryString(table, sb));
                            }
                            return;
                        }
                    }
                    Utils.joinAndAppendNamesAndValues(null, this.mgr.getCodecRegistry(), builder, " AND ", "=", pkeys, null);
                }
            }
            catch (EmptyOptionalPrimaryKeyException e) {
                return;
            }
        }
        builders.add(this.finishBuildingQueryString(table, builder));
    }

    private StringBuilder finishBuildingQueryString(TableInfoImpl<T> table, StringBuilder builder) {
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        } else if (!((ConditionsImpl)this.conditions).conditions.isEmpty()) {
            for (ClauseImpl c : ((ConditionsImpl)this.conditions).conditions) {
                c.validate(table);
            }
            builder.append(" IF ");
            Utils.joinAndAppend(this.getKeyspace(), table, null, this.mgr.getCodecRegistry(), builder, " AND ", ((ConditionsImpl)this.conditions).conditions, null);
        }
        return builder;
    }

    @Override
    protected int simpleSize() {
        if (this.simpleSize == -1) {
            this.simpleSize = !this.isEnabled() ? 0 : this.tables.size();
        }
        return this.simpleSize;
    }

    @Override
    protected StringBuilder[] buildQueryStrings() {
        if (!this.isEnabled()) {
            return null;
        }
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>(this.tables.size());
        InsertImpl<T> insert = null;
        for (TableInfoImpl<T> table : this.tables) {
            if ((table.getTable().type() == Table.Type.AUDIT || table.getTable().type() == Table.Type.NO_DELETE) && this.columnNames == null && ((WhereImpl)this.where).clauses.isEmpty()) {
                if (insert == null) {
                    insert = this.init(new InsertImpl<T>(this.getPOJOContext(), table, ((OptionsImpl)this.usings).usings, this.mgr, this.bridge));
                    continue;
                }
                insert.into(table);
                continue;
            }
            this.buildQueryString(table, builders);
        }
        if (insert != null) {
            insert.buildQueryStrings(builders);
        }
        if (builders.isEmpty()) {
            return null;
        }
        return builders.toArray(new StringBuilder[builders.size()]);
    }

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("BATCH");
    }

    public Stream<TableInfo<T>> tables() {
        return this.tables.stream().map(t -> t);
    }

    public Delete.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public Delete.Where<T> where() {
        return this.where;
    }

    public Delete.Options<T> using(Using<?> using) {
        return this.usings.and(using);
    }

    public Stream<Using<?>> usings() {
        return ((OptionsImpl)this.usings).usings.stream();
    }

    public <U> Optional<Using<U>> getUsing(String name) {
        return this.usings().filter(u -> u.getName().equals(name)).findAny();
    }

    public Delete<T> ifExists() {
        Validate.isTrue((boolean)((ConditionsImpl)this.conditions).conditions.isEmpty(), (String)"cannot combined additional conditions with IF EXISTS", (Object[])new Object[0]);
        if (!this.ifExists) {
            this.setDirty();
            this.ifExists = true;
        }
        return this;
    }

    public Delete.Conditions<T> onlyIf(Clause condition) {
        return this.conditions.and(condition);
    }

    public Delete.Conditions<T> onlyIf() {
        Validate.isTrue((!this.ifExists ? 1 : 0) != 0, (String)"cannot combined additional conditions with IF EXISTS", (Object[])new Object[0]);
        return this.conditions;
    }

    public static class ConditionsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, DeleteImpl<T>>
    implements Delete.Conditions<T> {
        private final List<ClauseImpl> conditions;

        ConditionsImpl(DeleteImpl<T> statement) {
            this(statement, new ArrayList<ClauseImpl>(10));
        }

        ConditionsImpl(DeleteImpl<T> statement, List<ClauseImpl> conditions) {
            super(statement);
            this.conditions = conditions;
        }

        public Delete.Conditions<T> and(Clause condition) {
            Validate.notNull((Object)condition, (String)"invalid null condition", (Object[])new Object[0]);
            Validate.isTrue((!((DeleteImpl)this.statement).ifExists ? 1 : 0) != 0, (String)"cannot combined additional conditions with IF EXISTS", (Object[])new Object[0]);
            Validate.isTrue((boolean)(condition instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{condition.getClass().getName()});
            ClauseImpl c = (ClauseImpl)condition;
            Validate.isTrue((boolean)"=".equals(c.getOperation()), (String)"unsupported condition: %s", (Object[])new Object[]{c});
            ClassInfoImpl cinfo = this.getPOJOContext().getClassInfo();
            if (c instanceof ClauseImpl.Compound) {
                ((ClauseImpl.Compound)((Object)c)).getColumnNames().forEach(name -> cinfo.validateColumn(name));
            } else {
                cinfo.validateColumn(c.getColumnName().toString());
            }
            this.conditions.add(c);
            this.setDirty();
            return this;
        }

        public Delete.Where<T> where(Clause clause) {
            return ((DeleteImpl)this.statement).where(clause);
        }

        public Delete.Options<T> using(Using<?> using) {
            return ((DeleteImpl)this.statement).using(using);
        }
    }

    public static class SelectionImpl<T>
    extends BuilderImpl<T>
    implements Delete.Selection<T> {
        SelectionImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            super(context, mgr, bridge);
        }

        private Delete.Selection<T> addName(Object name) {
            this.context.getClassInfo().validateColumn(name);
            if (this.columnNames == null) {
                this.columnNames = new ArrayList<Object>(25);
            }
            this.columnNames.add(name);
            return this;
        }

        public Delete.Builder<T> all() {
            Validate.validState((this.columnNames == null ? 1 : 0) != 0, (String)"some columns (%s) have already been selected", (Object[])new Object[]{StringUtils.join((Iterable)this.columnNames, (String)", ")});
            this.allSelected = true;
            return this;
        }

        public Delete.Selection<T> column(String name) {
            return this.addName(name);
        }

        public Delete.Selection<T> listElt(String columnName, int idx) {
            return this.addName(new Utils.CNameIndex(columnName, idx));
        }

        public Delete.Selection<T> mapElt(String columnName, Object key) {
            return this.addName(new Utils.CNameKey(columnName, key));
        }
    }

    public static class BuilderImpl<T>
    implements Delete.Builder<T> {
        protected final StatementManagerImpl mgr;
        protected final StatementBridge bridge;
        protected final ClassInfoImpl.Context context;
        protected List<Object> columnNames;
        protected boolean allSelected = false;

        BuilderImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
            this.mgr = mgr;
            this.bridge = bridge;
            this.context = context;
        }

        BuilderImpl(ClassInfoImpl.Context context, List<Object> columnNames, StatementManagerImpl mgr, StatementBridge bridge) {
            this(context, mgr, bridge);
            context.getClassInfo().validateColumns(columnNames);
            this.columnNames = columnNames;
        }

        public Class<T> getObjectClass() {
            return this.context.getObjectClass();
        }

        public ClassInfo<T> getClassInfo() {
            return this.context.getClassInfo();
        }

        public Delete<T> from(String ... tables) {
            if (this.columnNames == null) {
                this.allSelected = true;
            }
            return new DeleteImpl(this.context, tables, this.columnNames, this.allSelected, this.mgr, this.bridge);
        }

        public Delete<T> from(Stream<String> tables) {
            if (this.columnNames == null) {
                this.allSelected = true;
            }
            return new DeleteImpl(this.context, (String[])tables.toArray(String[]::new), this.columnNames, this.allSelected, this.mgr, this.bridge);
        }

        public Delete<T> fromAll() {
            if (this.columnNames == null) {
                this.allSelected = true;
            }
            return new DeleteImpl(this.context, null, this.columnNames, this.allSelected, this.mgr, this.bridge);
        }
    }

    public static class OptionsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, DeleteImpl<T>>
    implements Delete.Options<T> {
        private final List<UsingImpl<?>> usings;

        OptionsImpl(DeleteImpl<T> statement) {
            this(statement, new ArrayList(5));
        }

        OptionsImpl(DeleteImpl<T> statement, List<UsingImpl<?>> usings) {
            super(statement);
            this.usings = usings;
        }

        public Delete.Options<T> and(Using<?> using) {
            Validate.notNull(using, (String)"invalid null using", (Object[])new Object[0]);
            Validate.isTrue((boolean)(using instanceof UsingImpl), (String)"unsupported class of usings: %s", (Object[])new Object[]{using.getClass().getName()});
            this.usings.add(((UsingImpl)using).setStatement(this.statement));
            this.setDirty();
            return this;
        }

        public Delete.Where<T> where(Clause clause) {
            return ((DeleteImpl)this.statement).where(clause);
        }

        public Delete<T> ifExists() {
            return ((DeleteImpl)this.statement).ifExists();
        }

        public Delete.Conditions<T> onlyIf(Clause condition) {
            return ((DeleteImpl)this.statement).onlyIf(condition);
        }
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, DeleteImpl<T>>
    implements Delete.Where<T> {
        private final List<ClauseImpl> clauses = new ArrayList<ClauseImpl>(10);

        WhereImpl(DeleteImpl<T> statement) {
            super(statement);
        }

        private List<ClauseImpl> getClauses(TableInfoImpl<T> table) {
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(this.clauses);
            for (Map.Entry<String, Object> e : table.getFinalPrimaryKeyValues().entrySet()) {
                String name = e.getKey();
                if (this.clauses.stream().anyMatch(c -> c.containsColumn(name))) continue;
                clauses.add(new ClauseImpl.EqClauseImpl((CharSequence)name, e.getValue()));
            }
            return clauses;
        }

        public Delete.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            ClauseImpl c = (ClauseImpl)clause;
            if (!(c instanceof ClauseImpl.Delayed) && !(c instanceof ClauseImpl.DelayedWithObject)) {
                ClassInfoImpl.Context context = this.getContext();
                ClassInfoImpl cinfo = context.getClassInfo();
                if (c instanceof ClauseImpl.Compound) {
                    ClauseImpl.Compound cc = (ClauseImpl.Compound)((Object)c);
                    List<String> names = cc.getColumnNames();
                    List<?> values = cc.getColumnValues();
                    if (c instanceof ClauseImpl.CompoundEqClauseImpl) {
                        for (int i = 0; i < names.size(); ++i) {
                            String name = names.get(i);
                            cinfo.validateColumnOrKeyspaceKey(name);
                            if (!cinfo.isKeyspaceKey(name)) continue;
                            context.addKeyspaceKey(name, values.get(i));
                        }
                    } else {
                        for (String name : names) {
                            cinfo.validateColumn(name);
                        }
                    }
                } else {
                    String name = c.getColumnName().toString();
                    if (c instanceof ClauseImpl.EqClauseImpl) {
                        cinfo.validateColumnOrKeyspaceKey(name);
                        if (cinfo.isKeyspaceKey(name)) {
                            context.addKeyspaceKey(name, c.firstValue());
                        }
                    } else {
                        cinfo.validateColumn(name);
                    }
                }
            }
            this.clauses.add(c);
            this.setDirty();
            return this;
        }

        public Delete.Options<T> using(Using<?> using) {
            return ((DeleteImpl)this.statement).using(using);
        }

        public Delete<T> ifExists() {
            return ((DeleteImpl)this.statement).ifExists();
        }

        public Delete.Conditions<T> onlyIf(Clause condition) {
            return ((DeleteImpl)this.statement).onlyIf(condition);
        }
    }
}

