/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.helenus.driver.ObjectNotFoundException;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.StatementManager;
import org.helenus.driver.impl.ObjectSetImpl;

public class ListenableFutureImpl<T>
extends AbstractFuture<ObjectSet<T>> {
    protected final StatementManager.Context<T> context;
    private final ListenableFuture<ResultSet> future;

    ListenableFutureImpl(StatementManager.Context<T> context, ListenableFuture<ResultSet> future) {
        this.context = context;
        this.future = future;
    }

    protected void postProcess(ResultSet result) {
    }

    public ObjectSet<T> get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        try {
            ResultSet result = (ResultSet)this.future.get(timeout, unit);
            this.postProcess(result);
            return new ObjectSetImpl<T>(this.context, result);
        }
        catch (InvalidQueryException e) {
            ObjectNotFoundException.handleKeyspaceNotFound((Class)this.context.getObjectClass(), (InvalidQueryException)e);
            throw e;
        }
    }

    public ObjectSet<T> get() throws InterruptedException, ExecutionException {
        try {
            ResultSet result = (ResultSet)this.future.get();
            this.postProcess(result);
            return new ObjectSetImpl<T>(this.context, result);
        }
        catch (InvalidQueryException e) {
            ObjectNotFoundException.handleKeyspaceNotFound((Class)this.context.getObjectClass(), (InvalidQueryException)e);
            throw e;
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public void addListener(Runnable listener, Executor exec) {
        this.future.addListener(listener, exec);
    }
}

