/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.MetadataBridge;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.UserTypeBridge;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;

public class UDTCodecImpl<T>
extends TypeCodec<T> {
    private final UDTClassInfoImpl<T> cinfo;
    private final String keyspace;
    private volatile TypeCodec<UDTValue> icodec;
    private volatile boolean registered;

    public UDTCodecImpl(UDTClassInfoImpl<T> cinfo, String keyspace) {
        super((DataType)UserTypeBridge.instantiate(cinfo.mgr, cinfo, keyspace), cinfo.getObjectClass());
        this.cinfo = cinfo;
        this.keyspace = keyspace;
        this.icodec = TypeCodec.userType((UserType)this.getUserType());
        this.registered = false;
    }

    public UDTCodecImpl(UDTClassInfoImpl<T> cinfo, UserType definition) {
        super((DataType)definition, cinfo.getObjectClass());
        this.cinfo = cinfo;
        this.icodec = TypeCodec.userType((UserType)definition);
        this.keyspace = definition.getKeyspace();
        this.registered = true;
    }

    private UDTValue getUDTValue(T object) {
        if (object == null) {
            return null;
        }
        TableInfoImpl<T> table = this.cinfo.getTableImpl();
        if (table == null) {
            return null;
        }
        UDTValue uval = this.getUserType().newValue();
        int i = -1;
        for (UserType.Field coldef : uval.getType()) {
            ++i;
            String cname = coldef.getName();
            FieldInfoImpl<T> field = table.getColumnImpl(cname);
            if (field == null) continue;
            uval.set(i, field.getValue(object), field.getCodec(this.keyspace));
        }
        return uval;
    }

    protected UserType getUserType() {
        return (UserType)this.getCqlType();
    }

    protected void register(UserType definition) {
        UserType old = this.getUserType();
        Validate.isTrue((boolean)old.getTypeName().equals(definition.getTypeName()), (String)"incompatible udt definition 's type registered: %s; expecting: %s", (Object[])new Object[]{definition.getTypeName(), old.getTypeName()});
        Validate.isTrue((boolean)old.getKeyspace().equals(definition.getKeyspace()), (String)"incompatible udt definition's keyspace registered: %s; expecting: %s", (Object[])new Object[]{definition.getKeyspace(), old.getKeyspace()});
        this.icodec = TypeCodec.userType((UserType)definition);
        this.registered = true;
    }

    protected void deregister(UserType definition) {
        UserType old = this.getUserType();
        Validate.isTrue((boolean)old.getTypeName().equals(definition.getTypeName()), (String)"incompatible udt definition 's type deregistered: %s; expecting: %s", (Object[])new Object[]{definition.getTypeName(), old.getTypeName()});
        Validate.isTrue((boolean)old.getKeyspace().equals(definition.getKeyspace()), (String)"incompatible udt definition's keyspace deregistered: %s; expecting: %s", (Object[])new Object[]{definition.getKeyspace(), old.getKeyspace()});
        this.registered = false;
    }

    public T parse(String value) throws InvalidTypeException {
        if (StringUtils.isEmpty((CharSequence)value) || value.equals("NULL")) {
            return null;
        }
        TableInfoImpl<T> table = this.cinfo.getTableImpl();
        HashMap<String, String> values = new HashMap<String, String>(this.cinfo.getColumns().size() * 3 / 2);
        int i = ParseUtils.skipSpaces((String)value, (int)0);
        if (value.charAt(i++) != '{') {
            throw new InvalidTypeException("cannot parse '" + this.keyspace + "." + this.cinfo.getName() + "' value from \"" + value + "\", at character " + i + " expecting '{' but got '" + value.charAt(i) + "'");
        }
        if (value.charAt(i = ParseUtils.skipSpaces((String)value, (int)i)) == '}') {
            try {
                return this.cinfo.getObject(this.keyspace, values);
            }
            catch (ObjectConversionException e) {
                throw new InvalidTypeException("failed to parse '" + this.keyspace + "." + this.cinfo.getName() + "'; " + e.getMessage(), (Throwable)e);
            }
        }
        while (i < value.length()) {
            int n;
            try {
                n = ParseUtils.skipCQLId((String)value, (int)i);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException("cannot parse '" + this.keyspace + "." + this.cinfo.getName() + "' value from \"" + value + "\", cannot parse a CQL identifier at character " + i, (Throwable)e);
            }
            String name = value.substring(i, n);
            i = n;
            FieldInfoImpl<T> finfo = table.getColumnImpl(name);
            if (finfo == null) {
                throw new InvalidTypeException("unknown field " + name + " in value \"" + value + "\"");
            }
            i = ParseUtils.skipSpaces((String)value, (int)i);
            if (value.charAt(i++) != ':') {
                throw new InvalidTypeException("cannot parse '" + this.keyspace + "." + this.cinfo.getName() + "' value from \"" + value + "\", at character " + i + " expecting ':' but got '" + value.charAt(i) + "'");
            }
            i = ParseUtils.skipSpaces((String)value, (int)i);
            try {
                n = ParseUtils.skipCQLValue((String)value, (int)i);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException("cannot parse '" + this.keyspace + "." + this.cinfo.getName() + "' value from \"" + value + "\", invalid CQL value at character " + i, (Throwable)e);
            }
            String input = value.substring(i, n);
            values.put(name, input);
            i = n;
            i = ParseUtils.skipSpaces((String)value, (int)i);
            if (value.charAt(i) == '}') {
                try {
                    return this.cinfo.getObject(this.keyspace, values);
                }
                catch (ObjectConversionException e) {
                    throw new InvalidTypeException("failed to parse '" + this.keyspace + "." + this.cinfo.getName() + "'; " + e.getMessage(), (Throwable)e);
                }
            }
            if (value.charAt(i) != ',') {
                throw new InvalidTypeException("cannot parse '" + this.keyspace + "." + this.cinfo.getName() + "' value from \"" + value + "\", at character " + i + " expecting ',' but got '" + value.charAt(i) + "'");
            }
            ++i;
            i = ParseUtils.skipSpaces((String)value, (int)i);
        }
        throw new InvalidTypeException("Malformed '" + this.cinfo.getName() + "' value \"" + value + "\", missing closing '}'");
    }

    public String format(T value) throws InvalidTypeException {
        if (value == null) {
            return "NULL";
        }
        TableInfoImpl<T> table = this.cinfo.getTableImpl();
        StringBuilder sb = new StringBuilder(200);
        int i = 0;
        sb.append('{');
        for (UserType.Field field : (UserType)this.icodec.getCqlType()) {
            String cname = MetadataBridge.escapeId(field.getName());
            if (i > 0) {
                sb.append(',');
            }
            sb.append(cname).append(':');
            FieldInfoImpl<T> finfo = table.getColumnImpl(cname);
            if (finfo != null) {
                sb.append(finfo.getCodec(this.keyspace).format(finfo.getValue(value)));
            } else {
                sb.append("NULL");
            }
            ++i;
        }
        sb.append('}');
        return sb.toString();
    }

    public ByteBuffer serialize(T value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (!this.registered) {
            throw new InvalidTypeException("failed to serialize '" + this.keyspace + "." + this.cinfo.getName() + "'; no cluster-defined definition registered");
        }
        return this.icodec.serialize((Object)this.getUDTValue(value), protocolVersion);
    }

    public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (!this.registered) {
            throw new InvalidTypeException("failed to deserialize '" + this.keyspace + "." + this.cinfo.getName() + "'; no cluster-defined definition registered");
        }
        try {
            return this.cinfo.getObject((UDTValue)this.icodec.deserialize(bytes, protocolVersion));
        }
        catch (ObjectConversionException e) {
            throw new InvalidTypeException("failed to deserialize '" + this.keyspace + "." + this.cinfo.getName() + "'; " + e.getMessage(), (Throwable)e);
        }
    }
}

