/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTSubClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.info.FieldInfo;
import org.helenus.driver.info.UDTRootClassInfo;
import org.helenus.driver.info.UDTTypeClassInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.UDTRootEntity;

public class UDTRootClassInfoImpl<T>
extends UDTClassInfoImpl<T>
implements UDTRootClassInfo<T> {
    private final Map<Class<? extends T>, UDTTypeClassInfoImpl<? extends T>> ctypes;
    private final Map<String, UDTTypeClassInfoImpl<? extends T>> ntypes;

    UDTRootClassInfoImpl(StatementManagerImpl mgr, Class<T> clazz) {
        super(mgr, clazz, UDTRootEntity.class);
        Validate.isTrue((boolean)Modifier.isAbstract(clazz.getModifiers()), (String)"UDT root entity class '%s', must be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.ctypes = this.findTypeInfos(mgr);
        this.ntypes = this.ctypes.values().stream().collect(Collectors.toMap(tcinfo -> tcinfo.getType(), tcinfo -> tcinfo));
        this.validateAndComplementSchema();
    }

    UDTRootClassInfoImpl(UDTRootClassInfoImpl<? super T> rinfo, Class<T> clazz) {
        super(rinfo, clazz);
        Validate.isTrue((boolean)Modifier.isAbstract(clazz.getModifiers()), (String)"UDT root entity class '%s', must be abstract", (Object[])new Object[]{clazz.getSimpleName()});
        this.ctypes = rinfo.ctypes;
        this.ntypes = rinfo.ntypes;
    }

    private Map<Class<? extends T>, UDTTypeClassInfoImpl<? extends T>> findTypeInfos(StatementManagerImpl mgr) {
        Validate.notNull((Object)this.clazz, (String)"invalid null UDT root POJO class", (Object[])new Object[0]);
        UDTRootEntity re = this.clazz.getAnnotation(UDTRootEntity.class);
        int hsize = re.types().length * 3 / 2;
        HashMap<Class<T>, UDTTypeClassInfoImpl<T>> types = new HashMap<Class<T>, UDTTypeClassInfoImpl<T>>(hsize);
        HashSet<String> names = new HashSet<String>(hsize);
        for (Class type : re.types()) {
            Validate.isTrue((boolean)this.clazz.isAssignableFrom(type), (String)"type class '%s' must extends UDT root element class: %s", (Object[])new Object[]{type.getName(), this.clazz.getName()});
            UDTTypeClassInfoImpl tcinfo = new UDTTypeClassInfoImpl(mgr, this, type, false);
            Validate.isTrue((types.put(tcinfo.getObjectClass(), tcinfo) == null ? 1 : 0) != 0, (String)"duplicate type element class '%s' defined for UDT root element class '%s'", (Object[])new Object[]{type.getSimpleName(), this.clazz.getSimpleName()});
            Validate.isTrue((boolean)names.add(tcinfo.getType()), (String)"duplicate type name '%s' defined by class '%s' for UDT root element class '%s'", (Object[])new Object[]{tcinfo.getType(), type.getSimpleName(), this.clazz.getSimpleName()});
        }
        return types;
    }

    private void validateAndComplementSchema() {
        TableInfoImpl table = this.getTableImpl();
        Validate.isTrue((boolean)table.getTypeKey().isPresent(), (String)"%s must annotate one field as a type key for table '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), table.getName()});
        this.ctypes.values().forEach(tcinfo -> tcinfo.getTableImpl().getNonPrimaryKeys().stream().forEach(c -> table.addNonPrimaryColumn(c)));
        this.getTableImpl().getColumnsImpl().forEach(c -> {
            if (c.isMandatory() && !this.ctypes.values().stream().allMatch(tcinfo -> tcinfo.getTableImpl().getColumn(c.getColumnName()).map(FieldInfo::isMandatory).orElse(false))) {
                table.forceNonPrimaryColumnToNotBeMandatory(c);
            }
        });
    }

    UDTTypeClassInfoImpl<? extends T> addType(StatementManagerImpl mgr, Class<?> type) {
        Validate.isTrue((boolean)this.clazz.isAssignableFrom(type), (String)"type class '%s' must extends UDT root element class: %s", (Object[])new Object[]{type.getName(), this.clazz.getName()});
        UDTTypeClassInfoImpl tcinfo = new UDTTypeClassInfoImpl(mgr, this, type, true);
        Validate.isTrue((this.ctypes.put(tcinfo.getObjectClass(), tcinfo) == null ? 1 : 0) != 0, (String)"duplicate type element class '%s' defined for UDT root element class '%s'", (Object[])new Object[]{type.getSimpleName(), this.clazz.getSimpleName()});
        Validate.isTrue((this.ntypes.put(tcinfo.getType(), tcinfo) == null ? 1 : 0) != 0, (String)"duplicate type name '%s' defined by class '%s' for UDT root element class '%s'", (Object[])new Object[]{tcinfo.getType(), type.getSimpleName(), this.clazz.getSimpleName()});
        tcinfo.getTableImpl().getNonPrimaryKeys().stream().forEach(c -> {
            FieldInfoImpl rc = this.getTableImpl().getColumnImpl(c.getColumnName());
            Validate.isTrue((rc != null ? 1 : 0) != 0, (String)"UDT root element '%s' doesn't define column '%s' in pojo '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), c.getColumnName(), type.getSimpleName()});
            if (rc.getDeclaringClass().equals(c.getDeclaringClass())) {
                return;
            }
            Validate.isTrue((rc.getDataType().getMainType() == c.getDataType().getMainType() ? 1 : 0) != 0, (String)"incompatible type columns '%s.%s' of type '%s' and '%s.%s' of type '%s' in pojo '%s'", (Object[])new Object[]{c.getDeclaringClass().getSimpleName(), c.getName(), c.getDataType().getMainType(), rc.getDeclaringClass().getSimpleName(), rc.getName(), rc.getDataType().getMainType(), type.getSimpleName()});
        });
        return tcinfo;
    }

    UDTSubClassInfoImpl<? extends T> newSubClass(StatementManagerImpl mgr, Class<?> type) {
        Validate.isTrue((boolean)this.clazz.isAssignableFrom(type), (String)"subclass '%s' must extends root element class: %s", (Object[])new Object[]{type.getName(), this.clazz.getName()});
        UDTSubClassInfoImpl tcinfo = new UDTSubClassInfoImpl(this, type);
        Validate.isTrue((!this.ctypes.containsKey(tcinfo.getObjectClass()) ? 1 : 0) != 0, (String)"a type element class '%s' is already defined for UDT root element class '%s'", (Object[])new Object[]{type.getSimpleName(), this.clazz.getSimpleName()});
        TableInfoImpl table = tcinfo.getTableImpl();
        TableInfoImpl rt = this.getTableImpl();
        table.getNonPrimaryKeys().stream().forEach(c -> {
            FieldInfoImpl rc = rt.getColumnImpl(c.getColumnName());
            Validate.isTrue((rc != null ? 1 : 0) != 0, (String)"UDT root element '%s' doesn't define column '%s' in pojo '%s'", (Object[])new Object[]{this.clazz.getSimpleName(), c.getColumnName(), type.getSimpleName()});
            if (rc.getDeclaringClass().equals(c.getDeclaringClass())) {
                return;
            }
            Validate.isTrue((rc.getDataType().getMainType() == c.getDataType().getMainType() ? 1 : 0) != 0, (String)"incompatible type columns '%s.%s' of type '%s' and '%s.%s' of type '%s' in subclass '%s'", (Object[])new Object[]{c.getDeclaringClass().getSimpleName(), c.getName(), c.getDataType().getMainType(), rc.getDeclaringClass().getSimpleName(), rc.getName(), rc.getDataType().getMainType(), type.getSimpleName()});
        });
        return tcinfo;
    }

    @Override
    public Stream<Class<? extends T>> objectClasses() {
        return (Stream)Stream.concat(Stream.of(this.clazz), ((Stream)this.ctypes.values().stream().sequential()).map(t -> t.getObjectClass())).sequential();
    }

    @Override
    public Stream<ClassInfoImpl<? extends T>> classInfos() {
        return (Stream)Stream.concat(Stream.of(this), (Stream)this.ctypes.values().stream().sequential()).sequential();
    }

    @Override
    public Context newContext() {
        return new Context();
    }

    @Override
    public POJOContext newContext(T object) {
        return new POJOContext(object);
    }

    public <S extends T> UDTTypeClassInfoImpl<S> getType(Class<S> clazz) {
        return this.ctypes.get(clazz);
    }

    public UDTTypeClassInfoImpl<? extends T> getType(String name) {
        return this.ntypes.get(name);
    }

    public Stream<UDTTypeClassInfo<? extends T>> types() {
        return this.ntypes.values().stream();
    }

    public Stream<UDTTypeClassInfoImpl<? extends T>> typeImpls() {
        return this.ntypes.values().stream();
    }

    public int getNumTypes() {
        return this.ctypes.size();
    }

    @Override
    public T getObject(UDTValue uval) {
        if (uval == null) {
            return null;
        }
        FieldInfoImpl field = this.getTableImpl().getTypeKey().orElse(null);
        if (field != null) {
            String type = Objects.toString(field.decodeValue(uval), null);
            UDTTypeClassInfoImpl<T> tcinfo = this.ntypes.get(type);
            if (tcinfo == null) {
                throw new ObjectConversionException(this.clazz, uval, "unknown POJO type: " + type);
            }
            return tcinfo.getObject(uval, type);
        }
        throw new ObjectConversionException(this.clazz, uval, "missing POJO type column");
    }

    @Override
    public T getObject(String keyspace, Map<String, String> values) {
        if (values == null) {
            return null;
        }
        FieldInfoImpl field = this.getTableImpl().getTypeKey().orElse(null);
        if (field != null) {
            String type = values.get(field.getColumnName());
            UDTTypeClassInfoImpl<T> tcinfo = this.ntypes.get(type);
            if (tcinfo == null) {
                throw new ObjectConversionException(this.clazz, values, "unknown POJO type: " + type);
            }
            return tcinfo.getObject(keyspace, values);
        }
        throw new ObjectConversionException(this.clazz, values, "missing POJO type column");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ",clazz=" + this.clazz + ",keyspace=" + this.getKeyspace() + ",ntypes=" + this.ntypes + ",columns=" + this.getColumns() + ",table=" + this.getTableImpl() + "]";
    }

    public class POJOContext
    extends UDTClassInfoImpl.POJOContext {
        private final UDTClassInfoImpl.POJOContext tcontext;

        public POJOContext(T object) {
            super(object);
            UDTTypeClassInfoImpl tcinfo = (UDTTypeClassInfoImpl)UDTRootClassInfoImpl.this.ctypes.get(object.getClass());
            Validate.isTrue((tcinfo != null ? 1 : 0) != 0, (String)"invalid POJO class '%s'; expecting one of %s", (Object[])new Object[]{object.getClass().getName(), UDTRootClassInfoImpl.this.ctypes.keySet()});
            this.tcontext = tcinfo.newContextFromRoot(object);
        }

        @Override
        public Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> getKeyspaceKeyValues() {
            return this.tcontext.getKeyspaceKeyValues();
        }

        @Override
        public String getKeyspace() {
            return this.tcontext.getKeyspace();
        }

        @Override
        public void addKeyspaceKey(String name, Object value) {
            this.tcontext.addKeyspaceKey(name, value);
        }

        @Override
        public T getObject(Row row) {
            return this.tcontext.getObject(row);
        }

        @Override
        public Collection<T> getInitialObjects() {
            return this.tcontext.getInitialObjects().stream().collect(Collectors.toList());
        }
    }

    public class Context
    extends ClassInfoImpl.Context {
        private final Map<Class<? extends T>, ClassInfoImpl.Context> contexts;

        Context() {
            this.contexts = UDTRootClassInfoImpl.this.ctypes.values().stream().collect(Collectors.toMap(tcinfo -> tcinfo.getObjectClass(), tcinfo -> tcinfo.newContext()));
        }

        @Override
        public void addKeyspaceKey(String name, Object value) {
            super.addKeyspaceKey(name, value);
            this.contexts.values().forEach(tc -> tc.addKeyspaceKey(name, value));
        }
    }
}

