/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.Using;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;

public class UsingImpl<T>
extends Utils.Appendeable
implements Using<T> {
    private volatile StatementImpl<?, ?, ?> statement = null;
    private final String optionName;
    private T value;

    UsingImpl(String optionName, T value) {
        this.optionName = optionName;
        this.value = value;
    }

    UsingImpl(UsingImpl<T> using, StatementImpl<?, ?, ?> statement) {
        this.optionName = using.optionName;
        this.value = using.value;
        this.statement = statement;
    }

    UsingImpl<T> setStatement(StatementImpl<?, ?, ?> statement) {
        if (this.statement == null) {
            this.statement = statement;
            return this;
        }
        return new UsingImpl<T>(this, statement);
    }

    @Override
    void appendTo(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        sb.append(this.optionName).append(' ').append(this.value);
    }

    @Override
    boolean containsBindMarker() {
        return Utils.containsBindMarker(this.value);
    }

    public String getName() {
        return this.optionName;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        Validate.notNull(value, (String)"invalid null value", (Object[])new Object[0]);
        if (!Objects.equals(this.value, value)) {
            this.value = value;
            StatementImpl<?, ?, ?> s = this.statement;
            if (s != null) {
                s.setDirty();
            }
        }
    }

    public int hashCode() {
        return 0x1F ^ this.optionName.hashCode() ^ this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UsingImpl) {
            UsingImpl u = (UsingImpl)obj;
            return this.value.equals(u.getValue()) && this.optionName.equals(u.getName());
        }
        return false;
    }

    public String toString() {
        return this.optionName + "=" + this.value;
    }
}

