/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.helenus.driver.BindMarker;
import org.helenus.driver.Keywords;
import org.helenus.driver.codecs.ArgumentsCodec;
import org.helenus.driver.impl.AssignmentImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.DataType;

public abstract class Utils {
    private static final Pattern cnamePattern = Pattern.compile("\\w+(?:\\[.+\\])?");

    public static StringBuilder joinAndAppendNamesAndValues(TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, String separator, String keySeparator, Map<String, Triple<Object, CQLDataType, TypeCodec<?>>> mappings, List<Object> variables) {
        boolean first = true;
        for (Map.Entry<String, Triple<Object, CQLDataType, TypeCodec<?>>> e : mappings.entrySet()) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendName(sb, e.getKey()).append(keySeparator);
            Utils.appendValue((CQLDataType)e.getValue().getMiddle(), codec != null ? codec : (TypeCodec)e.getValue().getRight(), codecRegistry, sb, e.getValue().getLeft(), variables);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendWithNoDuplicates(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, String separator, Collection<? extends Appendeable> values, List<Object> variables) {
        HashSet<String> done = new HashSet<String>(values.size() * 3 / 2);
        boolean first = true;
        for (Appendeable appendeable : values) {
            StringBuilder vsb = new StringBuilder(10);
            appendeable.appendTo(keyspace, tinfo, codec, codecRegistry, vsb, variables);
            String vs = vsb.toString();
            if (!done.add(vs)) continue;
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(vs);
        }
        return sb;
    }

    public static StringBuilder joinAndAppend(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, String separator, Collection<? extends Appendeable> values, List<Object> variables) {
        boolean first = true;
        for (Appendeable appendeable : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            appendeable.appendTo(keyspace, tinfo, codec, codecRegistry, sb, variables);
        }
        return sb;
    }

    public static StringBuilder joinAndAppend(String keyspace, TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, String separator, Collection<? extends Appendeable> values, Collection<? extends Appendeable> moreValues, List<Object> variables) {
        boolean first = true;
        for (Appendeable appendeable : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            appendeable.appendTo(keyspace, tinfo, codec, codecRegistry, sb, variables);
        }
        for (Appendeable appendeable : moreValues) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            appendeable.appendTo(keyspace, tinfo, codec, codecRegistry, sb, variables);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendNames(TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, String separator, Iterable<?> values) {
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendName(tinfo, codec, codecRegistry, sb, value);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendValues(TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, String separator, Iterable<Triple<Object, CQLDataType, TypeCodec<?>>> values, List<Object> variables) {
        boolean first = true;
        for (Triple<Object, CQLDataType, TypeCodec<?>> value : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendValue((CQLDataType)value.getMiddle(), codec != null ? codec : (TypeCodec)value.getRight(), codecRegistry, sb, value.getLeft(), variables);
        }
        return sb;
    }

    public static StringBuilder joinAndAppendValues(TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, String separator, Iterable<?> values, CQLDataType definition, List<Object> variables) {
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            Utils.appendValue(definition, codec, codecRegistry, sb, value, variables);
        }
        return sb;
    }

    public static boolean isBindMarker(Object value) {
        return value instanceof BindMarker || value instanceof com.datastax.driver.core.querybuilder.BindMarker;
    }

    public static boolean containsBindMarker(Object value) {
        if (Utils.isBindMarker(value)) {
            return true;
        }
        if (value instanceof FCall) {
            for (Object p : ((FCall)value).parameters) {
                if (!Utils.containsBindMarker(p)) continue;
                return true;
            }
        } else {
            if (value instanceof Collection) {
                return ((Collection)value).stream().anyMatch(e -> Utils.containsBindMarker(value));
            }
            if (value instanceof Map) {
                return ((Map)value).entrySet().stream().anyMatch(e -> Utils.containsBindMarker(e.getKey()) || Utils.containsBindMarker(e.getValue()));
            }
        }
        return false;
    }

    public static boolean containsSpecialValue(Object value) {
        if (Utils.isBindMarker(value) || value instanceof FCName || value instanceof RawString) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().anyMatch(e -> Utils.containsSpecialValue(e));
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().anyMatch(e -> Utils.containsSpecialValue(e.getKey()) || Utils.containsSpecialValue(e.getValue()));
        }
        return false;
    }

    public static boolean isSerializable(Object value) {
        if (Utils.containsSpecialValue(value) || value instanceof Number && !(value instanceof BigInteger) && !(value instanceof BigDecimal)) {
            return false;
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().allMatch(e -> Utils.isSerializable(e));
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().allMatch(e -> Utils.isSerializable(e.getKey()) && Utils.isSerializable(e.getValue()));
        }
        return true;
    }

    public static boolean isIdempotent(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof AssignmentImpl) {
            return ((AssignmentImpl)value).isIdempotent();
        }
        if (value instanceof FCall) {
            return false;
        }
        if (value instanceof RawString) {
            return false;
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().allMatch(v -> Utils.isIdempotent(v));
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().allMatch(e -> Utils.isIdempotent(e.getKey()) && Utils.isIdempotent(e.getValue()));
        }
        if (value instanceof ClauseImpl) {
            return ((ClauseImpl)value).values().stream().allMatch(v -> Utils.isIdempotent(v));
        }
        return true;
    }

    static StringBuilder appendValue(CQLDataType definition, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, Object value, List<Object> variables) {
        if (value == null) {
            sb.append("null");
        } else if (Utils.isBindMarker(value)) {
            sb.append(value);
        } else if (value instanceof FCall) {
            FCall fcall = (FCall)value;
            sb.append(fcall.getName()).append("(");
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Utils.appendValue(null, codec, codecRegistry, sb, fcall.parameters[i], variables);
            }
            sb.append(")");
        } else if (value instanceof FCName) {
            Utils.appendName(null, codec, codecRegistry, sb, ((FCName)value).getName());
        } else if (value instanceof Cast) {
            Cast c = (Cast)value;
            sb.append("CAST(");
            Utils.appendName(null, codec, codecRegistry, sb, c.column);
            sb.append(" AS ").append(c.targetType).append(')');
        } else if (value instanceof RawString) {
            sb.append(value.toString());
        } else if (!(definition instanceof UDTClassInfoImpl) && !Utils.isSerializable(value)) {
            if (value instanceof List) {
                Utils.appendList(definition, codec, codecRegistry, sb, (List)value, null);
            } else if (definition != null && definition.getMainType() == DataType.ORDERED_SET && value instanceof Collection) {
                Utils.appendList(definition, codec, codecRegistry, sb, (Collection)value, null);
            } else if (value instanceof Set) {
                Utils.appendSet(definition, codec, codecRegistry, sb, (Set)value, null);
            } else if (value instanceof Map) {
                Utils.appendMap(definition, codec, codecRegistry, sb, (Map)value, null);
            } else if (codec != null) {
                sb.append(codec.format(value));
            } else {
                sb.append(codecRegistry.codecFor(value).format(value));
            }
        } else if (variables == null) {
            if (codec != null) {
                sb.append(codec.format(value));
            } else {
                sb.append(codecRegistry.codecFor(value).format(value));
            }
        } else {
            sb.append('?');
            variables.add(value);
        }
        return sb;
    }

    static StringBuilder appendList(CQLDataType definition, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, Collection<?> l, List<Object> variables) {
        CQLDataType vdef = definition.getElementType();
        TypeCodec ecodec = codec instanceof ArgumentsCodec ? ((ArgumentsCodec)codec).codec(0) : codec;
        sb.append('[');
        boolean first = true;
        for (Object elt : l) {
            if (elt == null) {
                throw new IllegalArgumentException("null are not supported in " + (l instanceof List ? "lists" : (l instanceof Set ? "sets" : "collections")));
            }
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendValue(vdef, ecodec, codecRegistry, sb, elt, variables);
        }
        sb.append(']');
        return sb;
    }

    static StringBuilder appendSet(CQLDataType definition, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, Set<?> s, List<Object> variables) {
        CQLDataType vdef = definition.getElementType();
        TypeCodec ecodec = codec instanceof ArgumentsCodec ? ((ArgumentsCodec)codec).codec(0) : codec;
        sb.append('{');
        boolean first = true;
        for (Object elt : s) {
            Validate.isTrue((elt != null ? 1 : 0) != 0, (String)"null are not supported in sets", (Object[])new Object[0]);
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendValue(vdef, ecodec, codecRegistry, sb, elt, variables);
        }
        sb.append('}');
        return sb;
    }

    static StringBuilder appendMap(CQLDataType definition, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, Map<?, ?> m, List<Object> variables) {
        TypeCodec vcodec;
        TypeCodec kcodec;
        CQLDataType kdef = definition.getFirstArgumentType();
        CQLDataType vdef = definition.getElementType();
        if (codec instanceof ArgumentsCodec) {
            ArgumentsCodec acodec = (ArgumentsCodec)codec;
            kcodec = acodec.codec(0);
            vcodec = acodec.codec(1);
        } else {
            kcodec = null;
            vcodec = codec;
        }
        sb.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object eval = entry.getValue();
            Validate.isTrue((eval != null ? 1 : 0) != 0, (String)"null are not supported in maps", (Object[])new Object[0]);
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendValue(kdef, kcodec, codecRegistry, sb, entry.getKey(), variables);
            sb.append(':');
            Utils.appendValue(vdef, vcodec, codecRegistry, sb, eval, variables);
        }
        sb.append('}');
        return sb;
    }

    public static StringBuilder appendName(StringBuilder sb, String name) {
        if (cnamePattern.matcher(name = name.trim()).matches() && !Keywords.isReserved((String)name) || name.startsWith("\"") || name.startsWith("token(") || name.contains("|")) {
            sb.append(name);
        } else {
            sb.append('\"').append(name).append('\"');
        }
        return sb;
    }

    static StringBuilder appendName(TableInfoImpl<?> tinfo, TypeCodec<?> codec, CodecRegistry codecRegistry, StringBuilder sb, Object name) {
        if (name instanceof String) {
            Utils.appendName(sb, (String)name);
        } else if (name instanceof CNameKey) {
            ((CNameKey)name).appendTo(tinfo, sb, codec, codecRegistry);
        } else if (name instanceof FCName) {
            Utils.appendName(sb, ((FCName)name).getName());
        } else if (name instanceof FCall) {
            FCall fcall = (FCall)name;
            sb.append(fcall.getName()).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(null, codec, codecRegistry, sb, fcall.parameters[i], null);
            }
            sb.append(")");
        } else if (name instanceof Alias) {
            Alias a = (Alias)name;
            sb.append("AS(");
            Utils.appendName(tinfo, codec, codecRegistry, sb, a.column);
            sb.append(" AS ").append(a.alias);
        } else if (name instanceof Cast) {
            Cast c = (Cast)name;
            sb.append("CAST(");
            Utils.appendName(tinfo, codec, codecRegistry, sb, c.column);
            sb.append(" AS ").append(c.targetType).append(')');
        } else if (name instanceof RawString) {
            sb.append(((RawString)name).str);
        } else if (name instanceof CharSequence) {
            Utils.appendName(sb, ((CharSequence)name).toString());
        } else {
            throw new IllegalArgumentException("invalid column '" + name + "' of unknown type: " + (name != null ? name.getClass().getName() : "null"));
        }
        return sb;
    }

    static class Cast {
        private final Object column;
        private final DataType targetType;

        Cast(Object column, DataType targetType) {
            this.column = column;
            this.targetType = targetType;
        }

        public String toString() {
            return String.format("CAST(%s AS %s)", this.column, this.targetType);
        }
    }

    public static class Alias {
        private final Object column;
        private final String alias;

        Alias(Object column, String alias) {
            this.column = column;
            this.alias = alias;
        }

        public String toString() {
            return String.format("%s AS %s", this.column, this.alias);
        }
    }

    public static class CNameSequence
    implements CharSequence {
        private final String[] names;
        private final String seq;

        CNameSequence(String seq, String ... names) {
            this.names = names;
            this.seq = seq;
        }

        public String getName() {
            return this.names[0];
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.seq.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.seq;
        }
    }

    public static class CNameKey
    extends CName {
        private final Object key;

        public CNameKey(String name, Object key) {
            super(name);
            this.key = key;
        }

        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb, TypeCodec<?> codec, CodecRegistry codecRegistry) {
            FieldInfoImpl<?> finfo;
            TypeCodec vcodec;
            TypeCodec kcodec;
            if (codec instanceof ArgumentsCodec) {
                ArgumentsCodec acodec = (ArgumentsCodec)codec;
                kcodec = acodec.codec(0);
                vcodec = acodec.codec(1);
            } else {
                kcodec = null;
                vcodec = codec;
            }
            Utils.appendName(sb, this.getColumnName());
            sb.append('[');
            if (tinfo != null && (finfo = tinfo.getColumnImpl(this.getColumnName())) != null) {
                codec = finfo.getCodec(null);
                if (codec instanceof ArgumentsCodec) {
                    ArgumentsCodec acodec = (ArgumentsCodec)codec;
                    if (kcodec == null) {
                        kcodec = acodec.codec(0);
                    }
                    if (vcodec == null) {
                        vcodec = acodec.codec(1);
                    }
                } else if (vcodec == null) {
                    vcodec = codec;
                }
                Utils.appendValue(finfo.getDataType(), kcodec, codecRegistry, sb, this.key, null);
                sb.append(']');
                return;
            }
            Utils.appendValue(null, vcodec, codecRegistry, sb, this.key, null);
            sb.append(']');
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Utils.appendName(sb, this.getColumnName());
            sb.append('[');
            Utils.appendValue(null, null, null, sb, this.key, null);
            return sb.append(']').toString();
        }
    }

    public static class CNameIndex
    extends CName {
        private final int idx;

        public CNameIndex(String name, int idx) {
            super(name);
            if (idx < 0) {
                throw new ArrayIndexOutOfBoundsException("invalid index '" + idx + "' for column '" + name + "'");
            }
            this.idx = idx;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Utils.appendName(sb, this.getColumnName());
            return sb.append('[').append(this.idx).append(']').toString();
        }
    }

    public static class CName
    extends FCName {
        public CName(String name) {
            super(name);
            Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        }

        public String getColumnName() {
            return this.getName();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class FCall
    extends FCName
    implements Iterable<Object> {
        private final Object[] parameters;

        public FCall(String name, Object ... parameters) {
            super(name);
            Validate.notNull((Object)name, (String)"invalid null operation name", (Object[])new Object[0]);
            this.parameters = parameters;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ObjectArrayIterator(this.parameters);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(this.parameters[i]);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static abstract class FCName {
        private final String name;

        FCName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class RawString {
        private final String str;

        public RawString(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    static abstract class Appendeable {
        Appendeable() {
        }

        abstract void appendTo(String var1, TableInfoImpl<?> var2, TypeCodec<?> var3, CodecRegistry var4, StringBuilder var5, List<Object> var6);

        abstract boolean containsBindMarker();
    }
}

