/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.regions.EhcacheEntityRegion;
import org.hibernate.cache.ehcache.internal.strategy.AbstractReadWriteEhcacheAccessStrategy;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ReadWriteEhcacheEntityRegionAccessStrategy
extends AbstractReadWriteEhcacheAccessStrategy<EhcacheEntityRegion>
implements EntityRegionAccessStrategy {
    public ReadWriteEhcacheEntityRegionAccessStrategy(EhcacheEntityRegion region, SessionFactoryOptions settings) {
        super(region, settings);
    }

    public EntityRegion getRegion() {
        return (EntityRegion)this.region();
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        ((EhcacheEntityRegion)this.region()).writeLock(key);
        try {
            AbstractReadWriteEhcacheAccessStrategy.Lockable item = (AbstractReadWriteEhcacheAccessStrategy.Lockable)((EhcacheEntityRegion)this.region()).get(key);
            if (item == null) {
                ((EhcacheEntityRegion)this.region()).put(key, new AbstractReadWriteEhcacheAccessStrategy.Item(value, version, ((EhcacheEntityRegion)this.region()).nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ((EhcacheEntityRegion)this.region()).writeUnlock(key);
        }
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        ((EhcacheEntityRegion)this.region()).writeLock(key);
        try {
            AbstractReadWriteEhcacheAccessStrategy.Lockable item = (AbstractReadWriteEhcacheAccessStrategy.Lockable)((EhcacheEntityRegion)this.region()).get(key);
            if (item != null && item.isUnlockable(lock)) {
                AbstractReadWriteEhcacheAccessStrategy.Lock lockItem = (AbstractReadWriteEhcacheAccessStrategy.Lock)item;
                if (lockItem.wasLockedConcurrently()) {
                    this.decrementLock(key, lockItem);
                    boolean bl = false;
                    return bl;
                }
                ((EhcacheEntityRegion)this.region()).put(key, new AbstractReadWriteEhcacheAccessStrategy.Item(value, currentVersion, ((EhcacheEntityRegion)this.region()).nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(key, item);
            boolean bl = false;
            return bl;
        }
        finally {
            ((EhcacheEntityRegion)this.region()).writeUnlock(key);
        }
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createEntityKey((Object)id, (EntityPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getEntityId((Object)cacheKey);
    }
}

