/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.query;

import java.util.Collections;
import org.hibernate.Query;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.QueryGeneratorTools;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public final class ThreeEntityQueryGenerator
implements RelationQueryGenerator {
    private final String queryString;
    private final MiddleIdData referencingIdData;

    public ThreeEntityQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, MiddleIdData indexIdData, MiddleComponentData ... componentDatas) {
        this.referencingIdData = referencingIdData;
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        String eeOriginalIdPropertyPath = "ee." + originalIdPropertyName;
        QueryBuilder qb = new QueryBuilder(versionsMiddleEntityName, "ee");
        qb.addFrom(referencedIdData.getVersionsEntityName(), "e");
        qb.addFrom(indexIdData.getVersionsEntityName(), "f");
        qb.addProjection("new list", "ee, e, f", false, false);
        Parameters rootParameters = qb.getRootParameters();
        referencedIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, referencedIdData.getOriginalMapper(), "e." + originalIdPropertyName);
        indexIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, indexIdData.getOriginalMapper(), "f." + originalIdPropertyName);
        referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        QueryGeneratorTools.addEntityAtRevision(globalCfg, qb, rootParameters, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e", "e2");
        QueryGeneratorTools.addEntityAtRevision(globalCfg, qb, rootParameters, indexIdData, revisionPropertyPath, originalIdPropertyName, "f", "f2");
        QueryGeneratorTools.addAssociationAtRevision(qb, rootParameters, referencingIdData, versionsMiddleEntityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, componentDatas);
        rootParameters.addWhereWithNamedParam(verEntCfg.getRevisionTypePropName(), "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("e." + verEntCfg.getRevisionTypePropName(), false, "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("f." + verEntCfg.getRevisionTypePropName(), false, "!=", "delrevisiontype");
        StringBuilder sb = new StringBuilder();
        qb.build(sb, Collections.<String, Object>emptyMap());
        this.queryString = sb.toString();
    }

    public Query getQuery(AuditReaderImplementor versionsReader, Object primaryKey, Number revision) {
        Query query = versionsReader.getSession().createQuery(this.queryString);
        query.setParameter("revision", (Object)revision);
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        for (QueryParameterData paramData : this.referencingIdData.getPrefixedMapper().mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }
}

