/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.KeepCheckResult;
import org.hibernate.envers.synchronization.work.KeepCheckVisitor;
import org.hibernate.persister.entity.EntityPersister;

public class ModWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final boolean changes;

    public ModWorkUnit(SessionImplementor sessionImplementor, String entityName, AuditConfiguration verCfg, Serializable id, EntityPersister entityPersister, Object[] newState, Object[] oldState) {
        super(sessionImplementor, entityName, verCfg, id);
        this.changes = verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().map(sessionImplementor, this.data, entityPersister.getPropertyNames(), newState, oldState);
    }

    public boolean containsWork() {
        return this.changes;
    }

    public void perform(Session session, Object revisionData) {
        this.fillDataWithId(this.data, revisionData, RevisionType.MOD);
        session.save(this.verCfg.getAuditEntCfg().getAuditEntityName(this.getEntityName()), this.data);
        this.setPerformed(this.data);
    }

    public KeepCheckResult check(AddWorkUnit second) {
        return KeepCheckResult.FIRST;
    }

    public KeepCheckResult check(ModWorkUnit second) {
        return KeepCheckResult.SECOND;
    }

    public KeepCheckResult check(DelWorkUnit second) {
        return KeepCheckResult.SECOND;
    }

    public KeepCheckResult check(CollectionChangeWorkUnit second) {
        return KeepCheckResult.FIRST;
    }

    public KeepCheckResult dispatch(KeepCheckVisitor first) {
        return first.check(this);
    }
}

