/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.hibernate.MappingException;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.entities.IdMappingData;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.entities.mapper.id.EmbeddedIdMapper;
import org.hibernate.envers.entities.mapper.id.MultipleIdMapper;
import org.hibernate.envers.entities.mapper.id.SingleIdMapper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.type.ImmutableType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdMetadataGenerator {
    private final AuditMetadataGenerator mainGenerator;

    IdMetadataGenerator(AuditMetadataGenerator auditMetadataGenerator) {
        this.mainGenerator = auditMetadataGenerator;
    }

    private void addIdProperties(Element parent, Iterator<Property> properties, SimpleMapperBuilder mapper, boolean key) {
        while (properties.hasNext()) {
            Property property = properties.next();
            Type propertyType = property.getType();
            if ("_identifierMapper".equals(property.getName())) continue;
            if (propertyType instanceof ImmutableType) {
                this.mainGenerator.getBasicMetadataGenerator().addBasic(parent, this.getIdPersistentPropertyAuditingData(property), property.getValue(), mapper, true, key);
                continue;
            }
            throw new MappingException("Type not supported: " + propertyType.getClass().getName());
        }
    }

    IdMappingData addId(PersistentClass pc) {
        AbstractIdMapper mapper;
        DefaultElement rel_id_mapping = new DefaultElement("properties");
        DefaultElement orig_id_mapping = new DefaultElement("composite-id");
        Property id_prop = pc.getIdentifierProperty();
        Component id_mapper = pc.getIdentifierMapper();
        if (id_mapper == null && id_prop == null) {
            return null;
        }
        if (id_mapper != null) {
            mapper = new MultipleIdMapper(((Component)pc.getIdentifier()).getComponentClassName());
            this.addIdProperties((Element)rel_id_mapping, id_mapper.getPropertyIterator(), (SimpleMapperBuilder)((Object)mapper), false);
            this.addIdProperties((Element)orig_id_mapping, id_mapper.getPropertyIterator(), null, true);
        } else if (id_prop.isComposite()) {
            Component id_component = (Component)id_prop.getValue();
            mapper = new EmbeddedIdMapper(this.getIdPropertyData(id_prop), id_component.getComponentClassName());
            this.addIdProperties((Element)rel_id_mapping, id_component.getPropertyIterator(), (SimpleMapperBuilder)((Object)mapper), false);
            this.addIdProperties((Element)orig_id_mapping, id_component.getPropertyIterator(), null, true);
        } else {
            mapper = new SingleIdMapper();
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)rel_id_mapping, this.getIdPersistentPropertyAuditingData(id_prop), id_prop.getValue(), (SimpleMapperBuilder)((Object)mapper), true, false);
            this.mainGenerator.getBasicMetadataGenerator().addBasic((Element)orig_id_mapping, this.getIdPersistentPropertyAuditingData(id_prop), id_prop.getValue(), null, true, true);
        }
        orig_id_mapping.addAttribute("name", this.mainGenerator.getVerEntCfg().getOriginalIdPropName());
        this.mainGenerator.addRevisionInfoRelation((Element)orig_id_mapping);
        return new IdMappingData(mapper, (Element)orig_id_mapping, (Element)rel_id_mapping);
    }

    private PropertyData getIdPropertyData(Property property) {
        return new PropertyData(property.getName(), property.getName(), property.getPropertyAccessorName(), ModificationStore.FULL);
    }

    private PropertyAuditingData getIdPersistentPropertyAuditingData(Property property) {
        return new PropertyAuditingData(property.getName(), property.getPropertyAccessorName(), ModificationStore.FULL, RelationTargetAuditMode.AUDITED, null, null, false);
    }
}

