/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.id;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.HibernateProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleIdMapper
extends AbstractIdMapper
implements SimpleIdMapperBuilder {
    private PropertyData propertyData;

    public SingleIdMapper() {
    }

    public SingleIdMapper(PropertyData propertyData) {
        this.propertyData = propertyData;
    }

    @Override
    public void add(PropertyData propertyData) {
        if (this.propertyData != null) {
            throw new AuditException("Only one property can be added!");
        }
        this.propertyData = propertyData;
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data) {
        if (data == null || obj == null) {
            return;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData);
        setter.set(obj, data.get(this.propertyData.getName()), null);
    }

    @Override
    public Object mapToIdFromMap(Map data) {
        if (data == null) {
            return null;
        }
        return data.get(this.propertyData.getName());
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)data;
            return hibernateProxy.getHibernateLazyInitializer().getIdentifier();
        }
        Getter getter = ReflectionTools.getGetter(data.getClass(), this.propertyData);
        return getter.get(data);
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        if (data != null) {
            data.put(this.propertyData.getName(), obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        if (obj == null) {
            data.put(this.propertyData.getName(), null);
        } else if (obj instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)obj;
            data.put(this.propertyData.getName(), hibernateProxy.getHibernateLazyInitializer().getIdentifier());
        } else {
            Getter getter = ReflectionTools.getGetter(obj.getClass(), this.propertyData);
            data.put(this.propertyData.getName(), getter.get(obj));
        }
    }

    public void mapToEntityFromEntity(Object objTo, Object objFrom) {
        if (objTo == null || objFrom == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(objFrom.getClass(), this.propertyData);
        Setter setter = ReflectionTools.getSetter(objTo.getClass(), this.propertyData);
        setter.set(objTo, getter.get(objFrom), null);
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        return new SingleIdMapper(new PropertyData(prefix + this.propertyData.getName(), this.propertyData));
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        ret.add(new QueryParameterData(this.propertyData.getName(), obj));
        return ret;
    }
}

