/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.dom4j.Element;
import org.hibernate.cfg.reveng.SimpleMetaAttribute;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.tool.hbm2x.MetaAttributeHelper;

public class MetaAttributeBinder {
    public static MultiMap mergeMetaMaps(MultiMap specific, MultiMap general) {
        MultiValueMap result = new MultiValueMap();
        MetaAttributeHelper.copyMultiMap((MultiMap)result, specific);
        if (general != null) {
            for (Object key : general.keySet()) {
                if (specific.containsKey(key)) continue;
                Collection ml = (Collection)general.get(key);
                for (SimpleMetaAttribute element : ml) {
                    if (!element.inheritable) continue;
                    result.put(key, (Object)element);
                }
            }
        }
        return result;
    }

    public static MetaAttribute toRealMetaAttribute(String name, List<?> values) {
        MetaAttribute attribute = new MetaAttribute(name);
        for (SimpleMetaAttribute element : values) {
            attribute.addValue(element.value);
        }
        return attribute;
    }

    public static MultiMap loadAndMergeMetaMap(Element classElement, MultiMap inheritedMeta) {
        return MetaAttributeBinder.mergeMetaMaps(MetaAttributeBinder.loadMetaMap(classElement), inheritedMeta);
    }

    protected static MultiMap loadMetaMap(Element element) {
        MultiValueMap result = new MultiValueMap();
        ArrayList<Element> metaAttributeList = new ArrayList<Element>();
        for (Object obj : element.elements("meta")) {
            metaAttributeList.add((Element)obj);
        }
        for (Element metaAttrib : metaAttributeList) {
            String attribute = metaAttrib.attributeValue("attribute");
            String value = metaAttrib.getText();
            String inheritStr = metaAttrib.attributeValue("inherit");
            boolean inherit = true;
            if (inheritStr != null) {
                inherit = Boolean.valueOf(inheritStr);
            }
            SimpleMetaAttribute ma = new SimpleMetaAttribute(value, inherit);
            result.put((Object)attribute, (Object)ma);
        }
        return result;
    }
}

