/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.HornetQIOErrorException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractSequentialFile;
import org.hornetq.journal.HornetQJournalBundle;
import org.hornetq.journal.HornetQJournalLogger;

public final class NIOSequentialFile
extends AbstractSequentialFile {
    private FileChannel channel;
    private RandomAccessFile rfile;
    private Semaphore maxIOSemaphore;
    private final int defaultMaxIO;
    private int maxIO;

    public NIOSequentialFile(SequentialFileFactory factory, String directory, String fileName, int maxIO, Executor writerExecutor) {
        super(directory, new File(directory + "/" + fileName), factory, writerExecutor);
        this.defaultMaxIO = maxIO;
    }

    public NIOSequentialFile(SequentialFileFactory factory, File file, int maxIO, Executor writerExecutor) {
        super(file.getParent(), new File(file.getPath()), factory, writerExecutor);
        this.defaultMaxIO = maxIO;
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockStart(int position) {
        return position;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.channel != null;
    }

    @Override
    public synchronized void open() throws IOException {
        this.open(this.defaultMaxIO, true);
    }

    @Override
    public void open(int maxIO, boolean useExecutor) throws IOException {
        try {
            this.rfile = new RandomAccessFile(this.getFile(), "rw");
            this.channel = this.rfile.getChannel();
            this.fileSize = this.channel.size();
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
        if (this.writerExecutor != null && useExecutor) {
            this.maxIOSemaphore = new Semaphore(maxIO);
            this.maxIO = maxIO;
        }
    }

    @Override
    public void fill(int position, int size, byte fillCharacter) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            bb.put(fillCharacter);
        }
        bb.flip();
        try {
            this.channel.position(position);
            this.channel.write(bb);
            this.channel.force(false);
            this.channel.position(0L);
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
        this.fileSize = this.channel.size();
    }

    @Override
    public synchronized void waitForClose() throws InterruptedException {
        while (this.isOpen()) {
            this.wait();
        }
    }

    @Override
    public synchronized void close() throws IOException, InterruptedException, HornetQException {
        super.close();
        if (this.maxIOSemaphore != null) {
            while (!this.maxIOSemaphore.tryAcquire(this.maxIO, 60L, TimeUnit.SECONDS)) {
                HornetQJournalLogger.LOGGER.errorClosingFile(this.getFileName());
            }
        }
        this.maxIOSemaphore = null;
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.rfile != null) {
                this.rfile.close();
            }
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
        this.channel = null;
        this.rfile = null;
        this.notifyAll();
    }

    @Override
    public int read(ByteBuffer bytes) throws Exception {
        return this.read(bytes, null);
    }

    @Override
    public synchronized int read(ByteBuffer bytes, IOAsyncTask callback) throws IOException, HornetQIllegalStateException {
        try {
            if (this.channel == null) {
                throw new HornetQIllegalStateException("File " + this.getFileName() + " has a null channel");
            }
            int bytesRead = this.channel.read(bytes);
            if (callback != null) {
                callback.done();
            }
            bytes.flip();
            return bytesRead;
        }
        catch (IOException e) {
            if (callback != null) {
                callback.onError(HornetQExceptionType.IO_ERROR.getCode(), e.getLocalizedMessage());
            }
            this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void sync() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.force(false);
            }
            catch (IOException e) {
                this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
                throw e;
            }
        }
    }

    @Override
    public long size() throws IOException {
        if (this.channel == null) {
            return this.getFile().length();
        }
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void position(long pos) throws IOException {
        try {
            super.position(pos);
            this.channel.position(pos);
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    public String toString() {
        return "NIOSequentialFile " + this.getFile();
    }

    @Override
    public SequentialFile cloneFile() {
        return new NIOSequentialFile(this.factory, this.getFile(), this.maxIO, this.writerExecutor);
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOAsyncTask callback) {
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            this.internalWrite(bytes, sync, callback);
        }
        catch (Exception e) {
            callback.onError(HornetQExceptionType.GENERIC_EXCEPTION.getCode(), e.getMessage());
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        this.internalWrite(bytes, sync, null);
    }

    @Override
    public void writeInternal(ByteBuffer bytes) throws Exception {
        this.internalWrite(bytes, true, null);
    }

    @Override
    protected ByteBuffer newBuffer(int size, int limit) {
        size = limit;
        return super.newBuffer(size, limit);
    }

    private void internalWrite(final ByteBuffer bytes, final boolean sync, final IOAsyncTask callback) throws IOException, HornetQIOErrorException, InterruptedException {
        if (!this.isOpen()) {
            if (callback == null) {
                throw HornetQJournalBundle.BUNDLE.fileNotOpened();
            }
            callback.onError(HornetQExceptionType.IO_ERROR.getCode(), "File not opened");
            return;
        }
        this.position.addAndGet(bytes.limit());
        if (this.maxIOSemaphore == null || callback == null) {
            try {
                this.doInternalWrite(bytes, sync, callback);
            }
            catch (IOException e) {
                this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            }
        } else {
            this.maxIOSemaphore.acquire();
            this.writerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            NIOSequentialFile.this.doInternalWrite(bytes, sync, callback);
                        }
                        catch (IOException e) {
                            HornetQJournalLogger.LOGGER.errorSubmittingWrite(e);
                            NIOSequentialFile.this.factory.onIOError((Exception)new HornetQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), NIOSequentialFile.this);
                            callback.onError(HornetQExceptionType.IO_ERROR.getCode(), e.getMessage());
                        }
                        catch (Throwable e) {
                            HornetQJournalLogger.LOGGER.errorSubmittingWrite(e);
                            callback.onError(HornetQExceptionType.IO_ERROR.getCode(), e.getMessage());
                        }
                    }
                    finally {
                        NIOSequentialFile.this.maxIOSemaphore.release();
                    }
                }
            });
        }
    }

    private void doInternalWrite(ByteBuffer bytes, boolean sync, IOAsyncTask callback) throws IOException {
        this.channel.write(bytes);
        if (sync) {
            this.sync();
        }
        if (callback != null) {
            callback.done();
        }
    }
}

