/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.AbstractSequentialFileFactory;
import org.hornetq.core.journal.impl.NIOSequentialFile;

public class NIOSequentialFileFactory
extends AbstractSequentialFileFactory {
    public NIOSequentialFileFactory(String journalDir) {
        this(journalDir, null);
    }

    public NIOSequentialFileFactory(String journalDir, IOCriticalErrorListener listener) {
        this(journalDir, false, 501760, 3333333, false, listener);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered) {
        this(journalDir, buffered, null);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered, IOCriticalErrorListener listener) {
        this(journalDir, buffered, 501760, 3333333, false, listener);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered, int bufferSize, int bufferTimeout, boolean logRates) {
        this(journalDir, buffered, bufferSize, bufferTimeout, logRates, null);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered, int bufferSize, int bufferTimeout, boolean logRates, IOCriticalErrorListener listener) {
        super(journalDir, buffered, bufferSize, bufferTimeout, logRates, listener);
    }

    @Override
    public SequentialFile createSequentialFile(String fileName, int maxIO) {
        if (maxIO < 1) {
            maxIO = 1;
        }
        return new NIOSequentialFile(this, this.journalDir, fileName, maxIO, this.writeExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        ByteBuffer buffer2 = null;
        try {
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError error) {
            WeakReference<Object> obj = new WeakReference<Object>(new Object());
            try {
                long timeout = System.currentTimeMillis() + 5000L;
                while (System.currentTimeMillis() > timeout && obj.get() != null) {
                    System.gc();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        return buffer2;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }
}

