/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RouteContextList;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.transaction.Transaction;

public final class RoutingContextImpl
implements RoutingContext {
    private final Map<SimpleString, RouteContextList> map = new HashMap<SimpleString, RouteContextList>();
    private Transaction transaction;
    private int queueCount;

    public RoutingContextImpl(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void clear() {
        this.transaction = null;
        this.map.clear();
        this.queueCount = 0;
    }

    @Override
    public void addQueue(SimpleString address, Queue queue) {
        RouteContextList listing = this.getContextListing(address);
        if (queue.isDurable()) {
            listing.getDurableQueues().add(queue);
        } else {
            listing.getNonDurableQueues().add(queue);
        }
        ++this.queueCount;
    }

    @Override
    public RouteContextList getContextListing(SimpleString address) {
        RouteContextList listing = this.map.get(address);
        if (listing == null) {
            listing = new ContextListing();
            this.map.put(address, listing);
        }
        return listing;
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void setTransaction(Transaction tx) {
        this.transaction = tx;
    }

    @Override
    public List<Queue> getNonDurableQueues(SimpleString address) {
        return this.getContextListing(address).getNonDurableQueues();
    }

    @Override
    public List<Queue> getDurableQueues(SimpleString address) {
        return this.getContextListing(address).getDurableQueues();
    }

    @Override
    public int getQueueCount() {
        return this.queueCount;
    }

    @Override
    public Map<SimpleString, RouteContextList> getContexListing() {
        return this.map;
    }

    private static class ContextListing
    implements RouteContextList {
        private final List<Queue> durableQueue = new ArrayList<Queue>(1);
        private final List<Queue> nonDurableQueue = new ArrayList<Queue>(1);

        private ContextListing() {
        }

        @Override
        public int getNumberOfDurableQueues() {
            return this.durableQueue.size();
        }

        @Override
        public int getNumberOfNonDurableQueues() {
            return this.nonDurableQueue.size();
        }

        @Override
        public List<Queue> getDurableQueues() {
            return this.durableQueue;
        }

        @Override
        public List<Queue> getNonDurableQueues() {
            return this.nonDurableQueue;
        }
    }
}

