/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.UnproposalListener;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.utils.TypedProperties;

public abstract class GroupHandlingAbstract
implements GroupingHandler {
    protected final Executor executor;
    protected final ManagementService managementService;
    protected final SimpleString address;
    final Set<UnproposalListener> listeners = Collections.newSetFromMap(new WeakHashMap());

    public GroupHandlingAbstract(Executor executor, ManagementService managementService, SimpleString address) {
        this.executor = executor;
        this.managementService = managementService;
        this.address = address;
    }

    @Override
    public void addListener(final UnproposalListener listener) {
        if (this.executor == null) {
            this.listeners.add(listener);
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    GroupHandlingAbstract.this.listeners.add(listener);
                }
            });
        }
    }

    protected void fireUnproposed(final SimpleString groupID) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (UnproposalListener listener : GroupHandlingAbstract.this.listeners) {
                    listener.unproposed(groupID);
                }
            }
        };
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void forceRemove(SimpleString groupid, SimpleString clusterName) throws Exception {
        this.remove(groupid, clusterName);
        this.sendUnproposal(groupid, clusterName, 0);
    }

    protected void sendUnproposal(SimpleString groupid, SimpleString clusterName, int distance) {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, groupid);
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, clusterName);
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance);
        Notification notification = new Notification(null, NotificationType.UNPROPOSAL, props);
        try {
            this.managementService.sendNotification(notification);
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.errorHandlingMessage(e);
        }
    }
}

