/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import java.io.File;
import java.io.Serializable;
import org.http4s.AttributeMap;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.HttpVersion;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Service$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.package$;
import org.http4s.util.NonEmptyList;
import org.http4s.util.NonEmptyList$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scalaz.Kleisli;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.stream.Process;

public final class FileService$ {
    public static FileService$ MODULE$;

    static {
        new FileService$();
    }

    public Kleisli<Task, Request, Response> apply(FileService.Config config) {
        return Service$.MODULE$.lift((Function1 & Serializable & scala.Serializable)req -> {
            String uriPath = req.pathInfo();
            return !uriPath.startsWith(config.pathPrefix()) ? Response$.MODULE$.fallthrough() : ((Task)this.getFile(config.systemPath() + '/' + package$.MODULE$.getSubPath(uriPath, config.pathPrefix())).map((Function1 & Serializable & scala.Serializable)f -> (Task)config.pathCollector().apply(f, (Object)config, req)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Task$.MODULE$.now((Object)None$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Task)x$1.fold((Function0 & Serializable & scala.Serializable)() -> Response$.MODULE$.fallthrough(), (Function1 & Serializable & scala.Serializable)x$2 -> config.cacheStrategy().cache(uriPath, (Response)x$2)));
        });
    }

    public Task<Option<Response>> org$http4s$server$staticcontent$FileService$$filesOnly(File file, FileService.Config config, Request req) {
        return Task$.MODULE$.now(file.isDirectory() ? new Some((Object)new Response(Status$.MODULE$.Unauthorized(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5())) : (!file.isFile() ? None$.MODULE$ : this.getPartialContentFile(file, config, req).orElse((Function0 & Serializable & scala.Serializable)() -> StaticFile$.MODULE$.fromFile(file, config.bufferSize(), (Option)new Some((Object)req), config.executor()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Response)x$3.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader()}))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            Some some = (Some)option;
            long end2 = BoxesRunTime.unboxToLong((Object)some.value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    private Option<Response> getPartialContentFile(File file, FileService.Config config, Request req) {
        return req.headers().get((HeaderKey.Extractable)Range$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option e;
            Option option;
            Range range = x0$1;
            Option option2 = Range$.MODULE$.unapply(range);
            if (option2.isEmpty()) return None$.MODULE$;
            RangeUnit rangeUnit = (RangeUnit)((Tuple2)option2.get())._1();
            NonEmptyList nonEmptyList = (NonEmptyList)((Tuple2)option2.get())._2();
            RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
            RangeUnit rangeUnit3 = rangeUnit;
            if (rangeUnit2 == null) {
                if (rangeUnit3 != null) {
                    return None$.MODULE$;
                }
            } else if (!rangeUnit2.equals(rangeUnit3)) return None$.MODULE$;
            if ((option = NonEmptyList$.MODULE$.unapplySeq(nonEmptyList)).isEmpty()) return None$.MODULE$;
            if (((Tuple2)option.get())._2() == null) return None$.MODULE$;
            if (((LinearSeqOptimized)((Tuple2)option.get())._2()).lengthCompare(0) != 0) return None$.MODULE$;
            Range.SubRange subRange = (Range.SubRange)((Tuple2)option.get())._1();
            if (subRange == null) return None$.MODULE$;
            long s = subRange.first();
            if (!this.validRange(s, (Option<Object>)(e = subRange.second()), file.length())) return None$.MODULE$;
            long size = file.length();
            long start = s >= 0L ? s : scala.math.package$.MODULE$.max(0L, size + s);
            long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> size - 1L)));
            return StaticFile$.MODULE$.fromFile(file, start, end + 1L, config.bufferSize(), (Option)new Some((Object)req), config.executor()).map((Function1 & Serializable & scala.Serializable)resp -> {
                Headers hs = resp.headers().put((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader(), Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)new Some((Object)BoxesRunTime.boxToLong((long)size)))}));
                Status x$4 = Status$.MODULE$.PartialContent();
                Headers x$5 = hs;
                HttpVersion x$6 = resp.copy$default$2();
                Process x$7 = resp.copy$default$4();
                AttributeMap x$8 = resp.copy$default$5();
                return resp.copy(x$4, x$6, x$5, x$7, x$8);
            });
        });
    }

    private Option<File> getFile(String unsafePath) {
        File f = new File((String)package$.MODULE$.sanitize().apply((Object)unsafePath));
        return f.exists() ? new Some((Object)f) : None$.MODULE$;
    }

    private FileService$() {
        MODULE$ = this;
    }
}

