/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.io.file.Files$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.headers.Accept$minusRanges$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$1$;
import org.http4s.server.staticcontent.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString$;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileService$ {
    public static FileService$ MODULE$;
    private final Logger logger;

    static {
        new FileService$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Async<F> F) {
        LazyRef BadTraversal$module = new LazyRef();
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Paths.get(config.systemPath(), new String[0]).toRealPath(new LinkOption[0]));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Path rootPath = (Path)success.value();
            return TranslateUri$.MODULE$.apply(config.pathPrefix(), new Kleisli((Function1 & Serializable & scala.Serializable)request -> (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError((Object)this.resolvedPath$1((Request)request, rootPath, F, BadTraversal$module).semiflatMap((Function1 & Serializable & scala.Serializable)path -> F.delay((Function0 & Serializable & scala.Serializable)() -> path.toRealPath(LinkOption.NOFOLLOW_LINKS)), (Monad)F).collect((PartialFunction)new scala.Serializable(rootPath){
                public static final long serialVersionUID = 0L;
                private final Path rootPath$1;

                public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1.startsWith(this.rootPath$1) ? A1.toFile() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Path x1) {
                    Path path = x1;
                    boolean bl = path.startsWith(this.rootPath$1);
                    return bl;
                }
                {
                    this.rootPath$1 = rootPath$1;
                }
            }, (Functor)F).flatMap((Function1 & Serializable & scala.Serializable)f -> (OptionT)config.pathCollector().apply(f, (Object)config, request), (Monad)F).semiflatMap((Function1 & Serializable & scala.Serializable)x$2 -> config.cacheStrategy().cache(request.pathInfo(), x$2, F), (Monad)F), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F)), (PartialFunction)new scala.Serializable(F, BadTraversal$module){
                public static final long serialVersionUID = 0L;
                private final Async F$1;
                private final LazyRef BadTraversal$module$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 instanceof NoSuchFileException ? OptionT$.MODULE$.none((Applicative)this.F$1) : (FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(A1) ? OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), (Object)new Response(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)this.F$1) : function1.apply(x2));
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = throwable instanceof NoSuchFileException ? true : FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(throwable);
                    return bl;
                }
                {
                    this.F$1 = F$1;
                    this.BadTraversal$module$1 = BadTraversal$module$1;
                }
            }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F))), OptionT$.MODULE$.catsDataMonoidKForOptionT(F));
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NoSuchFileException) {
                if (!this.logger.isErrorEnabled()) return new Kleisli((Function1 & Serializable & scala.Serializable)x$3 -> OptionT$.MODULE$.none((Applicative)F));
                this.logger.error(new StringBuilder(110).append("Could not find root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will return none.").toString());
                return new Kleisli((Function1 & Serializable & scala.Serializable)x$3 -> OptionT$.MODULE$.none((Applicative)F));
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        if (!this.logger.isErrorEnabled()) return new Kleisli((Function1 & Serializable & scala.Serializable)x$4 -> OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), (Object)new Response(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)F));
        this.logger.error(new StringBuilder(117).append("Could not resolve root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will fail with a 500.").toString(), e);
        return new Kleisli((Function1 & Serializable & scala.Serializable)x$4 -> OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), (Object)new Response(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)F));
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$filesOnly(File file, FileService.Config<F> config, Request<F> req, Async<F> F) {
        return new OptionT(F.defer((Function0 & Serializable & scala.Serializable)() -> file.isDirectory() ? StaticFile$.MODULE$.fromFile(new File(file, "index.html"), (Option)new Some((Object)req), Files$.MODULE$.forAsync(F), (MonadError)F).value() : (!file.isFile() ? F.pure((Object)None$.MODULE$) : new OptionT(MODULE$.getPartialContentFile(file, config, req, F)).orElse((Function0 & Serializable & scala.Serializable)() -> StaticFile$.MODULE$.fromFile(file, config.bufferSize(), (Option)new Some((Object)req), StaticFile$.MODULE$.calcETag(Files$.MODULE$.forAsync(F), (Functor)F), Files$.MODULE$.forAsync(F), (MonadError)F).map((Function1 & Serializable & scala.Serializable)x$5 -> (Response)x$5.putHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance())})), (Functor)F), (Monad)F).value())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            Some some = (Some)option;
            long end2 = BoxesRunTime.unboxToLong((Object)some.value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F> F getPartialContentFile(File file, FileService.Config<F> config, Request<F> req, Async<F> F) {
        Object object;
        Option option;
        Object object2;
        Some some;
        Range range;
        Option option2 = Headers$.MODULE$.get$extension0(req.headers(), Header.Select$.MODULE$.singleHeaders(Range$.MODULE$.headerInstance()));
        if (option2 instanceof Some && (range = (Range)(some = (Some)option2).value()) != null) {
            RangeUnit rangeUnit = range.unit();
            NonEmptyList nonEmptyList = range.ranges();
            RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
            RangeUnit rangeUnit3 = rangeUnit;
            if (!(rangeUnit2 != null ? !rangeUnit2.equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList != null) {
                Range.SubRange subRange = (Range.SubRange)nonEmptyList.head();
                List list = nonEmptyList.tail();
                if (subRange != null) {
                    long s = subRange.first();
                    Option e = subRange.second();
                    if (Nil$.MODULE$.equals(list)) {
                        object2 = this.validRange(s, (Option<Object>)e, file.length()) ? F.defer((Function0 & Serializable & scala.Serializable)() -> {
                            long size = file.length();
                            long start = s >= 0L ? s : scala.math.package$.MODULE$.max(0L, size + s);
                            long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> size - 1L)));
                            return StaticFile$.MODULE$.fromFile(file, start, end + 1L, config.bufferSize(), (Option)new Some((Object)req), StaticFile$.MODULE$.calcETag(Files$.MODULE$.forAsync(F), (Functor)F), Files$.MODULE$.forAsync(F), (MonadError)F).map((Function1 & Serializable & scala.Serializable)resp -> {
                                List hs = Headers$.MODULE$.put$extension(resp.headers(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)new Some((Object)BoxesRunTime.boxToLong((long)size))), Content$minusRange$.MODULE$.headerInstance())}));
                                Status x$1 = Status$.MODULE$.PartialContent();
                                List x$2 = hs;
                                HttpVersion x$3 = resp.copy$default$2();
                                Stream x$4 = resp.copy$default$4();
                                Vault x$5 = resp.copy$default$5();
                                return resp.copy(x$1, x$3, x$2, x$4, x$5);
                            }, (Functor)F).value();
                        }) : FileService$.nope$1(F, file);
                        return (F)object2;
                    }
                }
            }
        }
        if ((option = Headers$.MODULE$.get$extension1(req.headers(), CIString$.MODULE$.apply("Range"))) instanceof Some) {
            object = FileService$.nope$1(F, file);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            object = F.pure((Object)None$.MODULE$);
        }
        object2 = object;
        return (F)object2;
    }

    private static final /* synthetic */ FileService$BadTraversal$1$ BadTraversal$lzycompute$1(LazyRef BadTraversal$module$1) {
        FileService$BadTraversal$1$ fileService$BadTraversal$1$;
        LazyRef lazyRef = BadTraversal$module$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$1$ = BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : (FileService$BadTraversal$1$)BadTraversal$module$1.initialize((Object)new FileService$BadTraversal$1$());
        }
        return fileService$BadTraversal$1$;
    }

    public final FileService$BadTraversal$1$ org$http4s$server$staticcontent$FileService$$BadTraversal$2(LazyRef BadTraversal$module$1) {
        return BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : FileService$.BadTraversal$lzycompute$1(BadTraversal$module$1);
    }

    private final OptionT resolvedPath$1(Request request$1, Path rootPath$1, Async F$1, LazyRef BadTraversal$module$1) {
        Vector segments = (Vector)request$1.pathInfo().segments().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            boolean x$12 = true;
            Charset x$2 = x$1.decoded$default$1();
            Function1 x$3 = x$1.decoded$default$3();
            return x$1.decoded(x$2, x$12, x$3);
        }, Vector$.MODULE$.canBuildFrom());
        return request$1.pathInfo().isEmpty() ? OptionT.PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), (Object)rootPath$1, (Applicative)F$1) : OptionT$.MODULE$.liftF(F$1.catchNonFatal((Function0 & Serializable & scala.Serializable)() -> (Path)segments.foldLeft((Object)rootPath$1, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            String string;
            boolean bl;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null && (bl = "".equals(string = (String)tuple2._2()) ? true : (".".equals(string) ? true : "..".equals(string)))) {
                throw this.org$http4s$server$staticcontent$FileService$$BadTraversal$2(BadTraversal$module$1);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            String segment = (String)tuple2._2();
            Path path2 = path.resolve(segment);
            return path2;
        }), Predef$.MODULE$.$conforms()), (Functor)F$1);
    }

    public static final /* synthetic */ Some $anonfun$getPartialContentFile$2(long size) {
        Status x$1 = Status$.MODULE$.RangeNotSatisfiable();
        List x$2 = Headers$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(0L, size - 1L), (Option)new Some((Object)BoxesRunTime.boxToLong((long)size))), Content$minusRange$.MODULE$.headerInstance())}));
        HttpVersion x$3 = Response$.MODULE$.apply$default$2();
        Stream x$4 = Response$.MODULE$.apply$default$4();
        Vault x$5 = Response$.MODULE$.apply$default$5();
        return new Some((Object)new Response(x$1, x$3, x$2, x$4, x$5));
    }

    private static final Object nope$1(Async F$3, File file$2) {
        return package.all$.MODULE$.toFunctorOps(F$3.delay((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> file$2.length()), (Functor)F$3).map((Function1 & Serializable & scala.Serializable)size -> FileService$.$anonfun$getPartialContentFile$2(BoxesRunTime.unboxToLong((Object)size)));
    }

    private FileService$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.server.staticcontent.FileService");
    }
}

