/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.provider;

import java.util.ArrayList;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;
import org.xmlpull.v1.XmlPullParser;

public class PrivacyProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        Privacy privacy = new Privacy();
        privacy.addExtension((PacketExtension)new DefaultPacketExtension(parser.getName(), parser.getNamespace()));
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("active")) {
                    String activeName = parser.getAttributeValue("", "name");
                    if (activeName == null) {
                        privacy.setDeclineActiveList(true);
                        continue;
                    }
                    privacy.setActiveName(activeName);
                    continue;
                }
                if (parser.getName().equals("default")) {
                    String defaultName = parser.getAttributeValue("", "name");
                    if (defaultName == null) {
                        privacy.setDeclineDefaultList(true);
                        continue;
                    }
                    privacy.setDefaultName(defaultName);
                    continue;
                }
                if (!parser.getName().equals("list")) continue;
                this.parseList(parser, privacy);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return privacy;
    }

    public void parseList(XmlPullParser parser, Privacy privacy) throws Exception {
        boolean done = false;
        String listName = parser.getAttributeValue("", "name");
        ArrayList<PrivacyItem> items = new ArrayList<PrivacyItem>();
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("item")) continue;
                items.add(this.parseItem(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("list")) continue;
            done = true;
        }
        privacy.setPrivacyList(listName, items);
    }

    public PrivacyItem parseItem(XmlPullParser parser) throws Exception {
        PrivacyItem item;
        boolean done = false;
        String actionValue = parser.getAttributeValue("", "action");
        String orderValue = parser.getAttributeValue("", "order");
        String type = parser.getAttributeValue("", "type");
        boolean allow = true;
        if ("allow".equalsIgnoreCase(actionValue)) {
            allow = true;
        } else if ("deny".equalsIgnoreCase(actionValue)) {
            allow = false;
        }
        int order = Integer.parseInt(orderValue);
        if (type != null) {
            String value = parser.getAttributeValue("", "value");
            item = new PrivacyItem(PrivacyItem.Type.valueOf(type), value, allow, order);
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("iq")) {
                        item.setFilterIQ(true);
                    }
                    if (parser.getName().equals("message")) {
                        item.setFilterMessage(true);
                    }
                    if (parser.getName().equals("presence-in")) {
                        item.setFilterPresenceIn(true);
                    }
                    if (!parser.getName().equals("presence-out")) continue;
                    item.setFilterPresenceOut(true);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("item")) continue;
                done = true;
            }
        } else {
            item = new PrivacyItem(allow, order);
        }
        return item;
    }
}

